/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor;

import com.tascape.reactor.AbstractCaseResource;
import com.tascape.reactor.SystemConfiguration;
import com.tascape.reactor.db.CaseResult;
import com.tascape.reactor.db.DbHandler;
import com.tascape.reactor.db.TaskCase;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCaseRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCaseRunner.class);
    private static final ThreadLocal<CaseResult> CASE_RESULT = new ThreadLocal();
    protected SystemConfiguration sysConfig = SystemConfiguration.getInstance();
    protected DbHandler db = null;
    protected CaseResult tcr = null;
    protected String execId = "";

    public static void setCaseResult(CaseResult caseResult) {
        CASE_RESULT.set(caseResult);
    }

    public static CaseResult getCaseResult() {
        return CASE_RESULT.get();
    }

    public abstract void runTaskCase() throws Exception;

    protected void generateHtml(Path logFile) {
        Pattern http = Pattern.compile("((http|https)://\\S+)");
        Path html = logFile.getParent().resolve("log.html");
        LOG.trace("creating file {}", (Object)html);
        try (PrintWriter pw = new PrintWriter(html.toFile());){
            pw.println("<html><body><pre>");
            pw.println("<a href='../'>Suite Log Directory</a><br /><a href='./'>Case Log Directory</a>");
            pw.println();
            List lines = FileUtils.readLines((File)logFile.toFile(), (Charset)Charset.defaultCharset());
            ArrayList<File> files = new ArrayList<File>(Arrays.asList(logFile.getParent().toFile().listFiles()));
            for (String line : lines) {
                String newline = line.replaceAll(">", "&gt;");
                if ((newline = newline.replaceAll("<", "&lt;")).contains(" INFO  ")) {
                    newline = "<b>" + newline + "</b>";
                } else if (newline.contains(" WARN  ")) {
                    newline = "<font color='9F6000'><b>" + newline + "</b></font>";
                } else if (newline.contains(" ERROR ") || newline.contains("Failure in case") || newline.contains("AssertionError")) {
                    newline = "<font color='red'><b>" + newline + "</b></font>";
                } else {
                    Matcher m = http.matcher(line);
                    if (m.find()) {
                        String url = m.group(1);
                        String a = String.format("<a href='%s'>%s</a>", url, url);
                        newline = newline.replace(url, a);
                    }
                }
                boolean printLine = true;
                for (File file : files) {
                    String path = file.getAbsolutePath();
                    String name = file.getName();
                    if (!newline.contains(path)) continue;
                    if (name.endsWith(".png")) {
                        pw.printf("<a href=\"%s\" target=\"_blank\"><img src=\"%s\" width=\"360px\"/></a>", name, name);
                    }
                    String a = String.format("<a href=\"%s\" target=\"_blank\">%s</a>", name, name);
                    int len = newline.indexOf("    ");
                    pw.printf((len > 0 ? newline.substring(0, len + 5) : "") + a, new Object[0]);
                    pw.println();
                    files.remove(file);
                    printLine = false;
                    break;
                }
                if (!printLine) continue;
                pw.println(newline);
            }
            pw.println("</pre></body></html>");
            logFile.toFile().delete();
        }
        catch (IOException ex) {
            LOG.warn(ex.getMessage());
        }
    }

    Path newLogFile(TaskCase tc) throws IOException {
        String caseLogDir = tc.formatForLogPath() + "." + System.currentTimeMillis() + "." + this.tcr.getCaseEnv();
        Path caseLogPath = this.sysConfig.getLogPath().resolve(this.execId).resolve(caseLogDir);
        LOG.debug("Create case execution log directory {}", (Object)caseLogPath);
        if (!caseLogPath.toFile().mkdirs()) {
            throw new IOException("Cannot create log directory " + caseLogPath);
        }
        AbstractCaseResource.setCaseLogPath(caseLogPath);
        this.tcr.setLogDir(caseLogDir);
        Path logFile = caseLogPath.resolve("case.log");
        LOG.debug("Create log file {}", (Object)logFile);
        return this.addLog4jFileAppender(logFile);
    }

    Path addLog4jFileAppender(Path path) throws IOException {
        org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
        String pattern = "%d{HH:mm:ss.SSS} %-5p %t %C{1}.%M:%L - %m%n";
        final String threadName = Thread.currentThread().getName();
        FileAppender fa = new FileAppender((Layout)new PatternLayout(pattern), path.toFile().getAbsolutePath());
        class ThreadFilter
        extends Filter {
            ThreadFilter() {
            }

            public int decide(LoggingEvent event) {
                if (event.getThreadName().startsWith(threadName)) {
                    return 1;
                }
                return -1;
            }
        }
        fa.addFilter((Filter)new ThreadFilter());
        fa.setThreshold((Priority)this.sysConfig.getCaseLogLevel());
        fa.setImmediateFlush(true);
        fa.setAppend(true);
        fa.setName(path.toFile().getAbsolutePath());
        fa.activateOptions();
        rootLogger.addAppender((Appender)fa);
        return path;
    }

    void removeLog4jAppender(Path path) {
        if (path == null) {
            LOG.warn("Appender name is null");
            return;
        }
        org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
        Appender appender = rootLogger.getAppender(path.toFile().getAbsolutePath());
        if (appender != null) {
            appender.close();
            rootLogger.removeAppender(appender);
        }
    }
}

