/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor;

import com.tascape.reactor.ExecutionResult;
import com.tascape.reactor.SystemConfiguration;
import com.tascape.reactor.db.CaseResult;
import com.tascape.reactor.db.CaseResultMetric;
import com.tascape.reactor.db.DbHandler;
import com.tascape.reactor.task.AbstractCase;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.List;
import org.junit.ToBeImplementedException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseRunListener
extends RunListener {
    private static final Logger LOG = LoggerFactory.getLogger(CaseRunListener.class);
    private static final int CASE_RETRY = SystemConfiguration.getInstance().getCaseRetry();
    private DbHandler db = null;
    private CaseResult tcr = null;
    private Throwable throwable;

    public CaseRunListener(DbHandler db, CaseResult tcr) {
        this.db = db;
        this.tcr = tcr;
    }

    public void testRunStarted(Description description) throws Exception {
        LOG.trace("Case class started {}", (Object)description.getClassName());
        if (this.db == null || this.tcr == null) {
            return;
        }
        Class<?> caseClass = Class.forName(description.getClassName());
        try {
            Field f = caseClass.getField("AUT");
            if (f != null) {
                this.tcr.setAut(f.get(null) + "");
            }
        }
        catch (NoSuchFieldException ex) {
            LOG.trace("{}", (Object)ex.getMessage());
        }
        long millis = System.currentTimeMillis();
        this.tcr.setStartTime(millis);
        this.tcr.setStopTime(millis + 11L);
        this.tcr.setResult(ExecutionResult.RUNNING);
        this.tcr.setCaseStation(SystemConfiguration.getInstance().getHostName());
        try {
            this.db.updateCaseExecutionResult(this.tcr);
        }
        catch (SQLException ex) {
            LOG.error("Cannot update case result", (Throwable)ex);
            throw ex;
        }
    }

    public void testAssumptionFailure(Failure failure) {
        LOG.error("{}", (Object)failure.getTestHeader(), (Object)failure.getException());
        this.throwable = failure.getException();
    }

    public void testStarted(Description description) throws Exception {
        LOG.info("Case method started: {}", (Object)description.getMethodName());
        AbstractCase kase = AbstractCase.getCase();
        if (kase != null) {
            String aut = kase.getApplicationUnderTask();
            if (aut == null || aut.isEmpty()) {
                return;
            }
            this.tcr.setAut(aut);
            this.db.updateCaseExecutionResult(this.tcr);
        }
        LOG.info("Application under task: {}", (Object)this.tcr.getAut());
    }

    public void testFailure(Failure failure) throws Exception {
        this.throwable = failure.getException();
        if (!(this.throwable instanceof ToBeImplementedException)) {
            LOG.warn("{} {}", (Object)failure.getDescription().getDisplayName(), (Object)this.throwable.getMessage());
        }
        if (this.db == null || this.tcr == null) {
            return;
        }
        if (this.throwable == null) {
            return;
        }
        this.tcr.setException(this.throwable);
    }

    public void testFinished(Description description) throws Exception {
        LOG.info("Case method finished: {}", (Object)description.getMethodName());
        if (this.db == null || this.tcr == null) {
            return;
        }
        AbstractCase kase = AbstractCase.getCase();
        if (kase == null) {
            return;
        }
        this.tcr.setExternalId(kase.getExternalId());
        kase.cleanBackgoundTasks();
        List<CaseResultMetric> resultMetrics = kase.getResultMetrics();
        if (!resultMetrics.isEmpty()) {
            this.db.saveCaseResultMetrics(this.tcr.getCaseResultId(), resultMetrics);
        }
    }

    public void testRunFinished(Result result) throws Exception {
        LOG.trace("Case class finished");
        boolean pass = result.wasSuccessful();
        float time = (float)result.getRunTime() / 1000.0f;
        if (pass) {
            LOG.info("PASS: {}, time: {} sec", (Object)pass, (Object)Float.valueOf(time));
        } else {
            LOG.error("PASS: {}, time: {} sec", (Object)pass, (Object)Float.valueOf(time));
        }
        if (this.throwable == null) {
            result.getFailures().stream().forEach(f -> LOG.error("Failure {}", (Object)f.getDescription(), (Object)f.getException()));
        }
        if (this.db == null || this.tcr == null) {
            return;
        }
        this.tcr.setStopTime(System.currentTimeMillis());
        this.tcr.setResult(pass ? ExecutionResult.PASS : ExecutionResult.FAIL);
        AbstractCase kase = AbstractCase.getCase();
        if (kase != null) {
            ExecutionResult er = kase.getExecutionResult();
            if (!ExecutionResult.NA.equals(er)) {
                LOG.debug("Overwriting JUnit4 execution engine result with the one from case - {}", (Object)er.result());
                this.tcr.setResult(er);
            }
        } else {
            LOG.warn("Null case? Case may have failed in environment setup.");
        }
        AbstractCase.setCase(null);
        this.checkExceptionToRequeue(this.throwable);
        this.db.updateCaseExecutionResult(this.tcr);
    }

    public void testIgnored(Description description) throws Exception {
        LOG.debug("{}", (Object)description);
    }

    public void throwException() {
        if (this.throwable != null) {
            throw new RuntimeException(this.throwable);
        }
    }

    private void checkExceptionToRequeue(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        int retry = this.tcr.getRetry();
        if (retry < CASE_RETRY) {
            LOG.info("Requeue/retry case {}", (Object)this.tcr.getTaskCase().format());
            this.tcr.setRetry(retry + 1);
            this.tcr.setResult(ExecutionResult.QUEUED);
        }
    }
}

