/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor;

import com.tascape.reactor.AbstractCaseRunner;
import com.tascape.reactor.CaseRunListener;
import com.tascape.reactor.ExecutionResult;
import com.tascape.reactor.data.AbstractCaseData;
import com.tascape.reactor.data.CaseData;
import com.tascape.reactor.db.CaseResult;
import com.tascape.reactor.db.DbHandler;
import com.tascape.reactor.db.SuiteProperty;
import com.tascape.reactor.db.SuiteResult;
import com.tascape.reactor.db.TaskCase;
import com.tascape.reactor.suite.AbstractSuite;
import com.tascape.reactor.suite.Environment;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseRunnerJUnit4
extends AbstractCaseRunner
implements Callable<CaseResult> {
    private static final Logger LOG = LoggerFactory.getLogger(CaseRunnerJUnit4.class);

    public CaseRunnerJUnit4(DbHandler db, CaseResult tcr) {
        this.db = db;
        this.tcr = tcr;
        this.execId = this.tcr.getSuiteResultId();
    }

    @Override
    public CaseResult call() throws Exception {
        this.tcr.setCaseEnv(Thread.currentThread().getName());
        Path logFile = this.newLogFile(this.tcr.getTaskCase());
        try {
            if (!this.db.acquireCaseResult(this.tcr)) {
                CaseResult caseResult = null;
                return caseResult;
            }
            AbstractCaseRunner.setCaseResult(this.tcr);
            this.injectCaseEnvironment();
            this.runTaskCase();
        }
        catch (Throwable ex) {
            LOG.error("Cannot execute case {}", (Object)this.tcr.getTaskCase().format(), (Object)ex);
            this.tcr.setResult(ExecutionResult.FAIL);
            this.tcr.setException(ex);
            this.db.updateCaseExecutionResult(this.tcr);
            throw ex;
        }
        finally {
            this.removeLog4jAppender(logFile);
            this.generateHtml(logFile);
        }
        return this.tcr;
    }

    @Override
    public void runTaskCase() throws Exception {
        AbstractCaseData.setCaseData(null);
        String caseDataInfo = this.tcr.getTaskCase().getCaseDataInfo();
        if (!caseDataInfo.isEmpty()) {
            CaseData caseData = AbstractCaseData.getCaseData(caseDataInfo);
            LOG.debug("Injecting case data: {} = {}", (Object)caseDataInfo, (Object)caseData.getValue());
            AbstractCaseData.setCaseData(caseData);
        }
        TaskCase tc = this.tcr.getTaskCase();
        LOG.debug("Loading case {}", (Object)tc.format());
        CaseRunListener trl = new CaseRunListener(this.db, this.tcr);
        JUnitCore core = new JUnitCore();
        core.addListener((RunListener)trl);
        core.run(Request.method(Class.forName(tc.getCaseClass()), (String)tc.getCaseMethod()));
    }

    private void injectCaseEnvironment() throws Exception {
        String suiteClass = this.tcr.getTaskCase().getSuiteClass();
        if (suiteClass == null || suiteClass.isEmpty()) {
            return;
        }
        Environment env = AbstractSuite.getEnvionment(suiteClass);
        if (env == null) {
            LOG.info("init suite runtime environment");
            AbstractSuite abstractSuite = (AbstractSuite)AbstractSuite.class.cast(Class.forName(suiteClass).newInstance());
            try {
                abstractSuite.setUp();
            }
            catch (Throwable t) {
                try {
                    abstractSuite.tearDown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw t;
            }
            AbstractSuite.addSuite(abstractSuite);
            env = AbstractSuite.getEnvionment(suiteClass);
            SuiteResult suitResult = this.tcr.getSuiteResult();
            if (StringUtils.isBlank((CharSequence)suitResult.getProductUnderTask())) {
                LOG.debug("Getting product-under-task");
                try {
                    String productUnderTask = abstractSuite.getProductUnderTask();
                    this.db.updateSuiteProductUnderTask(this.execId, productUnderTask);
                    suitResult.setProductUnderTask(productUnderTask);
                }
                catch (Exception ex) {
                    LOG.warn("Cannot get product-under-task", (Throwable)ex);
                }
            }
            SuiteProperty prop = new SuiteProperty();
            prop.setSuiteResultId(this.tcr.getSuiteResultId());
            prop.setPropertyName("reactor.case.env." + Thread.currentThread().getName());
            prop.setPropertyValue(env.getName());
            this.db.addSuiteExecutionProperty(prop);
        }
    }
}

