/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor;

import java.security.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionResult {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionResult.class);
    public static final ExecutionResult NA = new ExecutionResult("NA");
    public static final ExecutionResult QUEUED = new ExecutionResult("QUEUED");
    public static final ExecutionResult ACQUIRED = new ExecutionResult("ACQUIRED");
    public static final ExecutionResult RUNNING = new ExecutionResult("RUNNING");
    public static final ExecutionResult PASS = new ExecutionResult("PASS");
    public static final ExecutionResult FAIL = new ExecutionResult("FAIL");
    public static final ExecutionResult CANCEL = new ExecutionResult("CANCEL");
    public static final ExecutionResult TBI = new ExecutionResult("TBI");
    private String name = "";
    private int pass = 0;
    private int fail = 0;

    public static synchronized ExecutionResult newMultiple() {
        return new ExecutionResult("MULTIPLE");
    }

    private ExecutionResult(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPass(int pass) {
        if (pass < 0) {
            throw new InvalidParameterException("Negative integer is not supported.");
        }
        this.pass = pass;
    }

    public void setFail(int fail) {
        if (fail < 0) {
            throw new InvalidParameterException("Negative integer is not supported.");
        }
        this.fail = fail;
    }

    public String result() {
        if (this.pass != 0 || this.fail != 0) {
            return this.pass + "/" + this.fail;
        }
        return this.name;
    }

    public boolean equals(ExecutionResult er) {
        return this.result().equals(er.result());
    }

    public int getPass() {
        return this.pass;
    }

    public int getFail() {
        return this.fail;
    }

    public boolean isFailure() {
        return !this.name.equals("PASS") && this.fail != 0;
    }

    public static boolean isPass(String result) {
        return result.equals(ExecutionResult.PASS.name) || result.endsWith("/0");
    }

    public static void main(String[] args) {
        LOG.debug("tbi {}", (Object)TBI.isFailure());
        LOG.debug("{}", (Object)ExecutionResult.isPass(ExecutionResult.TBI.name));
    }
}

