/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor;

import com.tascape.reactor.SuiteRunner;
import com.tascape.reactor.SystemConfiguration;
import com.tascape.reactor.TaskSuite;
import com.tascape.reactor.Utils;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reactor {
    private static final Logger LOG = LoggerFactory.getLogger(Reactor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int exitCode = 0;
        try {
            SystemConfiguration config = SystemConfiguration.getInstance();
            config.listAppProperties();
            Utils.cleanDirectory(config.getLogPath().toFile().getAbsolutePath(), 240.0f, "lka_");
            String suiteClass = config.getSuite();
            Pattern caseClassRegex = config.getCaseClassRegex();
            Pattern caseMethodRegex = config.getCaseMethodRegex();
            LOG.debug("Running suite class: {}", (Object)suiteClass);
            TaskSuite ts = new TaskSuite(suiteClass, caseClassRegex, caseMethodRegex);
            if (ts.getCases().isEmpty()) {
                throw new RuntimeException("No cases found based on system properties");
            }
            SuiteRunner sr = new SuiteRunner(ts);
            exitCode = sr.runCases();
        }
        catch (Throwable t) {
            LOG.error("Reactor finishes with exception", t);
            exitCode = -1;
        }
        finally {
            if (exitCode != 0) {
                LOG.error("Reactor finishes with exit code {}", (Object)exitCode);
            }
            System.exit(exitCode);
        }
    }
}

