/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tascape.reactor.CaseRunnerJUnit4;
import com.tascape.reactor.ExecutionResult;
import com.tascape.reactor.Reactor;
import com.tascape.reactor.SystemConfiguration;
import com.tascape.reactor.TaskSuite;
import com.tascape.reactor.db.CaseResult;
import com.tascape.reactor.db.DbHandler;
import com.tascape.reactor.db.SuiteProperty;
import com.tascape.reactor.db.SuiteResult;
import com.tascape.reactor.db.TaskCase;
import com.tascape.reactor.suite.AbstractSuite;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuiteRunner {
    private static final Logger LOG = LoggerFactory.getLogger(SuiteRunner.class);
    private TaskSuite ts = null;
    private SuiteResult suitResult = null;
    private DbHandler db = null;
    private final SystemConfiguration SYS_CONFIG = SystemConfiguration.getInstance();
    private final String execId = this.SYS_CONFIG.getExecId();
    private static final Map<String, TaskCase> UNSUPPORTED_CASES = new HashMap<String, TaskCase>();

    public static synchronized void addUnspportedCase(TaskCase tc) {
        UNSUPPORTED_CASES.put(tc.format(), tc);
    }

    public SuiteRunner(TaskSuite taskSuite) throws Exception {
        LOG.debug("Run suite with execution id {}", (Object)this.execId);
        this.ts = taskSuite;
        this.db = DbHandler.getInstance();
        this.db.queueSuiteExecution(this.ts, this.execId);
        this.suitResult = new SuiteResult();
        this.suitResult.setSuiteResultId(this.execId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runCases() throws IOException, InterruptedException, SQLException, XMLStreamException {
        File dir = this.SYS_CONFIG.getLogPath().resolve(this.execId).toFile();
        LOG.debug("Create suite execution log directory {}", (Object)dir);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot create directory " + dir);
        }
        ExecutorService executorService = this.getExecutorService();
        ExecutorCompletionService completionService = new ExecutorCompletionService(executorService);
        this.saveExectionProperties(dir);
        LOG.debug("Start to acquire cases to execute");
        int loadLimit = this.SYS_CONFIG.getCaseLoadLimit();
        LOG.debug("Load queued cases {} per round", (Object)loadLimit);
        int numberOfFailures = 0;
        try {
            List<CaseResult> tcrs;
            while (!(tcrs = this.filter(this.db.getQueuedCaseResults(this.execId, loadLimit))).isEmpty()) {
                ArrayList futures = new ArrayList();
                tcrs.forEach(tcr -> {
                    tcr.setSuiteResult(this.suitResult);
                    LOG.debug("Submit case {}", (Object)tcr.getTaskCase().format());
                    futures.add(completionService.submit(new CaseRunnerJUnit4(this.db, (CaseResult)tcr)));
                });
                LOG.debug("Total {} cases submitted", (Object)futures.size());
                for (Future f : futures) {
                    try {
                        Future future = completionService.take();
                        CaseResult tcr2 = (CaseResult)future.get();
                        String result = tcr2.getResult().result();
                        LOG.debug("Get result of case {} - {}", (Object)tcr2.getTaskCase().format(), (Object)result);
                        if (result.equals(ExecutionResult.QUEUED.getName())) {
                            LOG.warn("do not record this re-queued case");
                            continue;
                        }
                        if (result.equals(ExecutionResult.TBI.getName())) {
                            LOG.warn("do not record this to-be-implemented case");
                            continue;
                        }
                        if (ExecutionResult.PASS.getName().equals(result) || result.endsWith("/0")) continue;
                        ++numberOfFailures;
                    }
                    catch (Throwable ex) {
                        LOG.error("Error executing case thread", ex);
                        ++numberOfFailures;
                    }
                }
            }
            LOG.debug("No more case to run on this host, updating suite execution result");
            this.db.updateSuiteExecutionResult(this.execId);
            this.db.adjustSuiteExecutionResult(this.execId);
        }
        finally {
            executorService.shutdown();
            AbstractSuite.getSuites().stream().forEach(suite -> {
                try {
                    suite.tearDown();
                }
                catch (Exception ex) {
                    LOG.warn("Error tearing down suite {}", suite.getClass(), (Object)ex);
                }
            });
        }
        this.db.exportToJson(this.execId);
        this.db.saveJunitXml(this.execId);
        return numberOfFailures;
    }

    private void saveExectionProperties(File dir) throws IOException, SQLException {
        File props = new File(dir, "execution.properties");
        this.SYS_CONFIG.getProperties().store(FileUtils.openOutputStream((File)props), Reactor.class.getName());
        ArrayList<SuiteProperty> sps = new ArrayList<SuiteProperty>();
        this.SYS_CONFIG.getProperties().entrySet().stream().filter((? super T key) -> !key.toString().startsWith("reactor.db.")).forEach(entry -> {
            SuiteProperty sp = new SuiteProperty();
            sp.setSuiteResultId(this.execId);
            sp.setPropertyName(entry.getKey().toString());
            sp.setPropertyValue(entry.getValue().toString());
            sps.add(sp);
        });
        this.db.setSuiteExecutionProperties(sps);
    }

    private ExecutorService getExecutorService() {
        int tc = this.SYS_CONFIG.getExecutionThreadCount();
        LOG.debug("thread count {}", (Object)tc);
        if (tc < 0) {
            throw new RuntimeException("Invalid execution thread number");
        }
        int env = this.ts.getNumberOfEnvs();
        LOG.debug("number of environment(s) {}", (Object)env);
        if (env < 0) {
            throw new RuntimeException("Invalid execution environment number");
        }
        int threadCount = tc == 0 ? (env == 0 ? 1 : env) : (env == 0 ? tc : Math.min(tc, env));
        LOG.debug("Start execution engine with {} thread(s)", (Object)threadCount);
        this.SYS_CONFIG.setExecutionThreadCount(threadCount);
        int len = (threadCount - 1 + "").length();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("th%0" + len + "d").build();
        ExecutorService executorService = Executors.newFixedThreadPool(threadCount, namedThreadFactory);
        return executorService;
    }

    private List<CaseResult> filter(List<CaseResult> tcrs) {
        List<CaseResult> tcrs0 = tcrs.stream().filter((? super T tcr) -> !UNSUPPORTED_CASES.containsKey(tcr.getTaskCase().format())).collect(Collectors.toList());
        if (SystemConfiguration.getInstance().isShuffleCases()) {
            LOG.debug("do case shuffle");
            Collections.shuffle(tcrs0);
        }
        return tcrs0;
    }
}

