/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor;

import com.tascape.reactor.Utils;
import com.tascape.reactor.suite.JUnit4Suite;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SystemConfiguration.class);
    public static final Path HOME_PATH = Paths.get(FileUtils.getUserDirectory().getAbsolutePath(), ".reactor");
    public static final String CONSTANT_SYSPROP_PREFIX = "reactor.";
    public static final String CONSTANT_SYSPROP_FILE = "reactor.properties";
    public static final String CONSTANT_LOG_KEEP_ALIVE_PREFIX = "lka_";
    public static final String CONSTANT_EXEC_ID_PREFIX = "rx_";
    public static final String SYSPROP_CONF_FILES = "reactor.conf.files";
    public static final String SYSPROP_EXECUTION_ID = "reactor.exec.id";
    public static final String SYSPROP_EXECUTION_THREAD_COUNT = "reactor.exec.thread.count";
    public static final String SYSPROP_CASE_LOAD_LIMIT = "reactor.case.load.limit";
    public static final String SYSPROP_CASE_STATION = "reactor.case.station";
    public static final String SYSPROP_CASE_RETRY = "reactor.case.retry";
    public static final String SYSPROP_LOG_PATH = "reactor.log.path";
    public static final String SYSPROP_CASE_SUITE = "reactor.case.suite";
    public static final String SYSPROP_SHUFFLE_CASES = "reactor.shuffle.cases";
    public static final String SYSPROP_RESULT_VISIBILITY = "reactor.result.visibility";
    public static final String SYSPROP_DEBUG_CLASS_REGEX = "reactor.debug.class.regex";
    public static final String SYSPROP_DEBUG_METHOD_RESGX = "reactor.debug.method.regex";
    public static final String SYSPROP_DEBUG_CLASS_EXCLUDE_REGEX = "reactor.debug.class.exclude.regex";
    public static final String SYSPROP_DEBUG_METHOD_EXCLUDE_RESGX = "reactor.debug.method.exclude.regex";
    public static final String SYSPROP_CASE_PRIORITY = "reactor.case.priority";
    public static final String SYSPROP_PRODUCT_UNDER_TASK = "reactor.product.under.task";
    public static final String SYSPROP_CASE_ENV = "reactor.case.env";
    public static final String SYSPROP_CASE_LOG_LEVEL = "reactor.case.log.level";
    public static final String SYSENV_JOB_NAME = "JOB_NAME";
    public static final String SYSENV_JOB_NUMBER = "BUILD_NUMBER";
    public static final String SYSENV_JOB_BUILD_URL = "BUILD_URL";
    private static final SystemConfiguration CONFIG = new SystemConfiguration();
    private final Properties properties = new Properties();

    public static SystemConfiguration getInstance() {
        return CONFIG;
    }

    private SystemConfiguration() {
        this.listSysProperties();
        try {
            LOG.info("Load properties from /{} on classpath", (Object)CONSTANT_SYSPROP_FILE);
            InputStream is = SystemConfiguration.class.getResourceAsStream("/reactor.properties");
            this.properties.load(is);
        }
        catch (IOException ex) {
            LOG.warn("", (Throwable)ex);
        }
        Path conf = HOME_PATH.resolve(CONSTANT_SYSPROP_FILE);
        Properties p = this.loadSystemPropertiesFromPath(conf);
        this.properties.putAll((Map<?, ?>)p);
        String confFiles = System.getProperty(SYSPROP_CONF_FILES, "").trim();
        if (StringUtils.isNotBlank((CharSequence)confFiles)) {
            LOG.trace("Load properties from {}", (Object)confFiles);
            String[] paths = confFiles.split(System.getProperty("path.separator"));
            Stream.of(paths).forEach(path -> this.properties.putAll((Map<?, ?>)this.loadSystemPropertiesFromPath(Paths.get(path, new String[0]))));
        }
        LOG.info("Load system properties starting with {}", (Object)CONSTANT_SYSPROP_PREFIX);
        ArrayList<String> keys = new ArrayList<String>(System.getProperties().stringPropertyNames());
        Properties sysProps = new Properties();
        keys.stream().filter(key -> key.startsWith(CONSTANT_SYSPROP_PREFIX) && StringUtils.isNotBlank((CharSequence)System.getProperty(key))).forEach(key -> sysProps.setProperty((String)key, System.getProperty(key)));
        this.properties.putAll((Map<?, ?>)sysProps);
        String execId = this.properties.getProperty(SYSPROP_EXECUTION_ID);
        if (StringUtils.isEmpty((CharSequence)execId)) {
            execId = Utils.getUniqueId(CONSTANT_EXEC_ID_PREFIX);
            LOG.warn("There is no execution id specified, using local new UUID: {}", (Object)execId);
            this.properties.setProperty(SYSPROP_EXECUTION_ID, execId);
        }
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        String v = this.properties.getProperty(name);
        if (StringUtils.isBlank((CharSequence)v)) {
            LOG.debug("System property '{}' is not defined, or blank, default value '{}' will be used", (Object)name, (Object)defaultValue);
            return defaultValue;
        }
        return v;
    }

    public int getIntProperty(String name) {
        String v = this.properties.getProperty(name);
        if (StringUtils.isBlank((CharSequence)v)) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(v);
    }

    public int getIntProperty(String name, int defaultValue) {
        String v = this.getProperty(name);
        if (StringUtils.isBlank((CharSequence)v)) {
            LOG.debug("System property '{}' is not defined, default value '{}' will be used", (Object)name, (Object)defaultValue);
            return defaultValue;
        }
        return Integer.parseInt(v);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String v = this.getProperty(name);
        if (StringUtils.isBlank((CharSequence)v)) {
            LOG.debug("System property '{}' is not defined, default value '{}' will be used", (Object)name, (Object)defaultValue);
            return defaultValue;
        }
        return Boolean.parseBoolean(v);
    }

    public boolean isShuffleCases() {
        return this.getBooleanProperty(SYSPROP_SHUFFLE_CASES, false);
    }

    public boolean getResultVisibility() {
        return this.getBooleanProperty(SYSPROP_RESULT_VISIBILITY, true);
    }

    public Path getLogPath() {
        String p = this.getProperty(SYSPROP_LOG_PATH);
        if (StringUtils.isBlank((CharSequence)p)) {
            return HOME_PATH.resolve("logs");
        }
        return Paths.get(p, new String[0]);
    }

    public int getCaseRetry() {
        return this.getIntProperty(SYSPROP_CASE_RETRY, 0);
    }

    public int getExecutionThreadCount() {
        return this.getIntProperty(SYSPROP_EXECUTION_THREAD_COUNT, 0);
    }

    public void setExecutionThreadCount(int count) {
        this.getProperties().setProperty(SYSPROP_EXECUTION_THREAD_COUNT, count + "");
    }

    public int getCaseLoadLimit() {
        return this.getIntProperty(SYSPROP_CASE_LOAD_LIMIT, 100);
    }

    public String getHostName() {
        String hn = this.getProperty(SYSPROP_CASE_STATION);
        if (StringUtils.isEmpty((CharSequence)hn)) {
            try {
                hn = Utils.cmd("hostname").get(0);
            }
            catch (IOException | InterruptedException ex) {
                LOG.trace("Cannot get host name", (Throwable)ex);
                hn = "unknow host";
            }
            this.properties.setProperty(SYSPROP_CASE_STATION, hn);
        }
        return hn;
    }

    public String getExecId() {
        return this.getProperty(SYSPROP_EXECUTION_ID);
    }

    public String getSuite() {
        String suite = this.getProperty(SYSPROP_CASE_SUITE);
        if (StringUtils.isBlank((CharSequence)suite)) {
            LOG.warn("There is no valid suite class name specified by system property {}", (Object)SYSPROP_CASE_SUITE);
            suite = JUnit4Suite.class.getName();
            LOG.warn("Use framework default {}", (Object)suite);
        }
        return suite;
    }

    public void setSuite(String suiteClassName) {
        this.properties.setProperty(SYSPROP_CASE_SUITE, suiteClassName);
    }

    public Pattern getCaseClassRegex() {
        String regex = this.getProperty(SYSPROP_DEBUG_CLASS_REGEX, ".+");
        return Pattern.compile(regex);
    }

    public Pattern getCaseMethodRegex() {
        String regex = this.getProperty(SYSPROP_DEBUG_METHOD_RESGX, ".+");
        return Pattern.compile(regex);
    }

    public int getCasePriority() {
        return this.getIntProperty(SYSPROP_CASE_PRIORITY, 3);
    }

    public String getDatabaseType() {
        return this.getProperty("reactor.db.type", "h2");
    }

    public String getDatabaseHost() {
        return this.getProperty("reactor.db.host", "127.0.0.1:3306");
    }

    public String getDatabaseSchema() {
        return this.getProperty("reactor.db.schema", "reactor");
    }

    public String getDatabaseUser() {
        return this.properties.getProperty("reactor.db.user", "reactor");
    }

    public String getDatabasePass() {
        return this.getProperty("reactor.db.pass", "p@ssword");
    }

    public int getDatabasePoolSize() {
        return this.getIntProperty("reactor.db.pool.size", this.getIntProperty(SYSPROP_EXECUTION_THREAD_COUNT) + 10);
    }

    public String getProdUnderTask() {
        return this.getProperty(SYSPROP_PRODUCT_UNDER_TASK, "");
    }

    public Level getCaseLogLevel() {
        String l = this.getProperty(SYSPROP_CASE_LOG_LEVEL, "DEBUG");
        return Level.toLevel((String)l);
    }

    public String getJobName() {
        String value = this.getProperty(this.pre(SYSENV_JOB_NAME));
        if (StringUtils.isBlank((CharSequence)value)) {
            value = System.getenv().get(SYSENV_JOB_NAME);
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            value = System.getProperty("user.name") + "@" + StringUtils.substringBefore((String)this.getHostName(), (String)".");
        }
        return value.trim();
    }

    public int getJobBuildNumber() {
        String value = this.getProperty(this.pre(SYSENV_JOB_NUMBER));
        if (StringUtils.isBlank((CharSequence)value)) {
            value = System.getenv().get(SYSENV_JOB_NUMBER);
        }
        try {
            return StringUtils.isBlank((CharSequence)value) ? 0 : Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            LOG.warn("Cannot parse {}={}", new Object[]{SYSENV_JOB_NUMBER, value, ex});
            return -1;
        }
    }

    public String getJobBuildUrl() {
        String value = this.getProperty(this.pre(SYSENV_JOB_BUILD_URL));
        if (StringUtils.isBlank((CharSequence)value)) {
            value = System.getenv().get(SYSENV_JOB_BUILD_URL);
        }
        return StringUtils.isBlank((CharSequence)value) ? "#" : value;
    }

    public void listAppProperties() {
        LOG.debug("Application properties");
        ArrayList<String> keys = new ArrayList<String>(this.properties.stringPropertyNames());
        Collections.sort(keys);
        keys.stream().filter(key -> !key.startsWith(this.pre("db."))).forEach(key -> LOG.debug(String.format("%50s : %s", key, this.properties.getProperty((String)key))));
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void listSysProperties() {
        ArrayList<String> keys = new ArrayList<String>(System.getProperties().stringPropertyNames());
        Collections.sort(keys);
        LOG.debug("Java system properties");
        for (String key : keys) {
            LOG.debug(String.format("%50s : %s", key, System.getProperties().getProperty(key)));
        }
        keys = new ArrayList<String>(System.getenv().keySet());
        Collections.sort(keys);
        LOG.debug("Java environment properties");
        for (String key : keys) {
            LOG.debug(String.format("%50s : %s", key, System.getenv().get(key)));
        }
    }

    private Properties loadSystemPropertiesFromPath(Path path) {
        File f = path.toFile();
        LOG.debug("Loading properties from {}", (Object)f.getAbsolutePath());
        Properties p = new Properties();
        if (!f.exists()) {
            LOG.warn("Cannot find properties file {}", (Object)path);
        } else {
            try (FileInputStream is = new FileInputStream(f);){
                p.load(is);
            }
            catch (IOException ex) {
                LOG.warn("Cannot load properties from {} - {}", (Object)path, (Object)ex.getMessage());
            }
        }
        return p;
    }

    private String pre(String name) {
        return CONSTANT_SYSPROP_PREFIX + name;
    }
}

