/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor;

import com.tascape.reactor.SystemConfiguration;
import com.tascape.reactor.data.AbstractCaseData;
import com.tascape.reactor.data.CaseData;
import com.tascape.reactor.data.CaseDataInfo;
import com.tascape.reactor.data.CaseDataProvider;
import com.tascape.reactor.db.TaskCase;
import com.tascape.reactor.suite.AbstractSuite;
import com.tascape.reactor.task.AbstractCase;
import com.tascape.reactor.task.Priority;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSuite {
    private static final Logger LOG = LoggerFactory.getLogger(TaskSuite.class);
    private String name;
    private final String projectName;
    private final int numberOfEnvs;
    private List<TaskCase> cases = new ArrayList<TaskCase>();

    public TaskSuite(String suiteClass, Pattern caseClassRegex, Pattern caseMethodRegex) throws Exception {
        LOG.debug("Find cases in target suite {}", (Object)suiteClass);
        AbstractSuite suite = (AbstractSuite)AbstractSuite.class.cast(Class.forName(suiteClass).newInstance());
        this.name = suite.getName();
        this.projectName = suite.getProjectName();
        this.numberOfEnvs = suite.getNumberOfEnvs();
        if (this.name == null || this.name.isEmpty()) {
            this.name = suiteClass;
        }
        suite.setUpCaseClasses();
        for (Class<? extends AbstractCase> clazz : suite.getCaseClasses()) {
            for (Method method : this.getCaseMethods(clazz)) {
                TaskCase tc = new TaskCase();
                tc.setSuiteClass(suiteClass);
                tc.setCaseClass(clazz.getName());
                tc.setCaseMethod(method.getName());
                this.cases.add(tc);
            }
        }
        this.cases = this.processAnnotations();
        this.cases = this.filter(caseClassRegex, caseMethodRegex);
        int priority = SystemConfiguration.getInstance().getIntProperty("reactor.case.priority", suite.getPriority());
        this.cases = this.filter(priority);
        if (SystemConfiguration.getInstance().isShuffleCases()) {
            LOG.debug("do case shuffle");
            Collections.shuffle(this.cases);
        }
    }

    public List<TaskCase> getCases() {
        return this.cases;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public int getNumberOfEnvs() {
        return this.numberOfEnvs;
    }

    private List<TaskCase> filter(Pattern caseClassRegex, Pattern caseMethodRegex) {
        LOG.debug("Use debug class  name fileter {}", (Object)caseClassRegex);
        LOG.debug("Use debug method name fileter {}", (Object)caseMethodRegex);
        ArrayList<TaskCase> tcs = new ArrayList<TaskCase>();
        this.cases.stream().forEach(tc -> {
            Matcher mc = caseClassRegex.matcher(tc.getCaseClass());
            Matcher mm = caseMethodRegex.matcher(tc.getCaseMethod());
            if (mc.find() && mm.find()) {
                tcs.add((TaskCase)tc);
            }
        });
        return tcs;
    }

    private List<TaskCase> filter(int priority) {
        LOG.debug("filter cases by priority {}", (Object)priority);
        return this.cases.stream().filter(tc -> tc.getPriority() <= priority).collect(Collectors.toList());
    }

    private List<TaskCase> processAnnotations() {
        LOG.debug("Checking method annotation CaseDataProvider for each case");
        ArrayList<TaskCase> tcs = new ArrayList<TaskCase>();
        this.cases.stream().forEach(tc -> {
            try {
                CaseDataProvider tdp;
                Class<?> caseClass = Class.forName(tc.getCaseClass());
                Method caseMethod = caseClass.getDeclaredMethod(tc.getCaseMethod(), new Class[0]);
                Priority p = caseMethod.getAnnotation(Priority.class);
                if (p != null) {
                    tc.setPriority(p.level());
                }
                if ((tdp = caseMethod.getAnnotation(CaseDataProvider.class)) == null) {
                    LOG.debug("Adding case {}", (Object)tc.format());
                    tcs.add((TaskCase)tc);
                } else {
                    LOG.trace("Calling class {}, method {}, with parameter {}", new Object[]{tdp.klass(), tdp.method(), tdp.parameter()});
                    CaseData[] data = AbstractCaseData.getCaseData(tdp.klass(), tdp.method(), tdp.parameter());
                    LOG.debug("{} is a data-driven case, data size is {}", (Object)tc.format(), (Object)data.length);
                    int length = (data.length + "").length();
                    for (int i = 0; i < data.length; ++i) {
                        TaskCase t = new TaskCase((TaskCase)tc);
                        CaseDataInfo tdi = new CaseDataInfo(tdp.klass(), tdp.method(), tdp.parameter(), i);
                        t.setCaseDataInfo(tdi.format(length));
                        String value = data[i].getValue();
                        if (StringUtils.isEmpty((CharSequence)value)) {
                            value = String.format("%s-%0" + length + "d", data[i].getClassName(), i);
                        }
                        t.setCaseData(value);
                        t.setPriority(Math.min(t.getPriority(), data[i].getPriority()));
                        LOG.debug("Adding case {}", (Object)t.format());
                        tcs.add(t);
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn("Cannot process case {}, skipping. Check {}", (Object)CaseDataProvider.class.getName(), (Object)tc.format());
                LOG.warn("", (Throwable)ex);
            }
        });
        return tcs;
    }

    private <T extends AbstractCase> List<Method> getCaseMethods(Class<T> caseClass) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : caseClass.getDeclaredMethods()) {
            if (m.getAnnotation(Test.class) == null) continue;
            methods.add(m);
        }
        return methods;
    }
}

