/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final String PASS = Utils.class + "_PASS";
    public static final String FAIL = Utils.class + "_FAIL";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd' 'HH:mm:ss.SSS";
    private static final String TIME_FORMAT = "HH:mm:ss.SSS";
    private static final String DATE_TIME_STRING = "yyyy_MM_dd_HH_mm_ss_SSS";
    public static final String FS = System.getProperty("file.separator");

    public static void openFile(File file) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.open(file);
        }
        catch (IOException ex) {
            LOG.warn("Cannot open file {}", (Object)file, (Object)ex);
        }
    }

    private Utils() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Please use Utils.method");
    }

    public static String formatDateTime(long milliSinceEpoch) {
        return new SimpleDateFormat(DATE_TIME_FORMAT).format(new Date(milliSinceEpoch));
    }

    public static String formatTime(long milliSinceEpoch) {
        return new SimpleDateFormat(TIME_FORMAT).format(new Date(milliSinceEpoch));
    }

    public static String formatTime(long milliSinceEpoch, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(new Date(milliSinceEpoch));
    }

    public static String getCurrentTime() {
        return new SimpleDateFormat(DATE_TIME_STRING).format(System.currentTimeMillis());
    }

    public static String getCurrentTime(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(new Date());
    }

    public static List<String> cmd(String command) throws IOException, InterruptedException {
        return Utils.cmd(command.split(" "));
    }

    public static List<String> cmd(String[] command) throws IOException, InterruptedException {
        return Utils.cmd(command, null, null, 300000L, null);
    }

    public static List<String> cmdWithWorkingDir(String[] command, String workindDir, long timeout) throws IOException, InterruptedException {
        return Utils.cmd(command, null, null, timeout, workindDir);
    }

    public static List<String> cmd(String[] command, String expected) throws IOException, InterruptedException {
        return Utils.cmd(command, expected, null, 300000L, null);
    }

    public static List<String> cmd(String[] command, String pass, String fail, final long timeout, String workingDir) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(command);
        if (workingDir != null) {
            pb.directory(new File(workingDir));
        }
        pb.redirectErrorStream(true);
        LOG.debug("Running command: " + pb.command().toString().replace(",", ""));
        final Process p = pb.start();
        ArrayList<String> output = new ArrayList<String>();
        if (timeout == 0L) {
            LOG.debug("This is a start-and-exit command");
            output.add(PASS);
            return output;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    LOG.debug("Command timeouts in {} ms", (Object)timeout);
                    Thread.sleep(timeout);
                    try {
                        p.exitValue();
                    }
                    catch (IllegalThreadStateException ex) {
                        LOG.debug("killing subprocess {} - {}", (Object)p, (Object)ex.getMessage());
                        p.destroy();
                    }
                }
                catch (InterruptedException ex) {
                    LOG.trace(ex.getMessage());
                }
            }
        };
        thread.setName(Thread.currentThread().getName() + "-" + p.hashCode());
        thread.setDaemon(true);
        thread.start();
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String c = p + " - ";
        String line = stdIn.readLine();
        while (line != null) {
            LOG.trace("{}{}", (Object)c, (Object)line);
            output.add(line);
            try {
                line = stdIn.readLine();
            }
            catch (IOException ex) {
                LOG.warn(ex.getMessage());
                break;
            }
        }
        LOG.debug("Command exit code {}", (Object)p.waitFor());
        thread.interrupt();
        try {
            stdIn.close();
        }
        catch (IOException ex) {
            LOG.warn("", (Throwable)ex);
        }
        for (String s : output) {
            if (pass != null && (s.contains(pass) || s.matches(pass))) {
                output.add(PASS);
                break;
            }
            if (fail == null || !s.contains(fail)) continue;
            output.add(FAIL);
            break;
        }
        return output;
    }

    public static Process cmd(String[] commands, File file) throws IOException {
        return Utils.cmd(commands, file, null, new String[0]);
    }

    public static Process cmd(String[] commands, File file, File workingDir) throws IOException {
        return Utils.cmd(commands, file, workingDir, new String[0]);
    }

    public static Process cmd(String[] commands, final File file, File workingDir, final String ... ignoreRegex) throws IOException {
        FileUtils.touch((File)file);
        LOG.debug("Saving console output to {}", (Object)file.getAbsolutePath());
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb.redirectErrorStream(true);
        pb.directory(workingDir);
        LOG.debug("Running command {}:  {}", (Object)(workingDir == null ? "" : workingDir.getAbsolutePath()), (Object)pb.command().toString().replaceAll(",", ""));
        final Process p = pb.start();
        Thread t = new Thread(Thread.currentThread().getName() + "-" + p.hashCode()){

            @Override
            public void run() {
                BufferedReader stdIn = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String console = "console-" + stdIn.hashCode();
                try (PrintWriter pw = new PrintWriter(file);){
                    String line = stdIn.readLine();
                    while (line != null) {
                        LOG.trace("{}: {}", (Object)console, (Object)line);
                        if (null == ignoreRegex || ignoreRegex.length == 0) {
                            pw.println(line);
                        } else {
                            boolean ignore = false;
                            for (String regex : ignoreRegex) {
                                if (regex.isEmpty() || !line.contains(regex) && !line.matches(regex)) continue;
                                ignore = true;
                                break;
                            }
                            if (!ignore) {
                                pw.println(line);
                            }
                        }
                        pw.flush();
                        line = stdIn.readLine();
                    }
                }
                catch (IOException ex) {
                    LOG.warn(ex.getMessage());
                }
                LOG.trace("command is done");
            }
        };
        t.setDaemon(true);
        t.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (p != null) {
                    p.destroy();
                }
            }
        });
        return p;
    }

    public static void waitForProcess(final Process process, final long timeout) throws InterruptedException {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException ex) {
                    LOG.warn(ex.getMessage());
                }
                finally {
                    if (process != null) {
                        process.destroy();
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
        if (process != null) {
            int exitValue = process.waitFor();
            LOG.trace("process {} exits with {}", (Object)process, (Object)exitValue);
        }
    }

    public static void waitForOutputLine(final Process process, String lineExpected, final long timeout) throws IOException {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException ex) {
                    LOG.warn(ex.getMessage());
                }
                finally {
                    if (process != null) {
                        process.destroy();
                    }
                }
            }
        };
        t.setName(Thread.currentThread().getName() + "-" + t.hashCode());
        t.setDaemon(true);
        t.start();
        try (BufferedReader stdIn = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = stdIn.readLine();
            while (line != null) {
                if (line.contains(lineExpected)) {
                    break;
                }
                line = stdIn.readLine();
            }
        }
        t.interrupt();
    }

    public static void deleteFileAfterMinutes(final File file, final int minutes) {
        file.deleteOnExit();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(minutes * 60000);
                    FileUtils.deleteQuietly((File)file);
                }
                catch (InterruptedException ex) {
                    LOG.trace(ex.getMessage());
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public static String getUniqueId() {
        return Utils.getUniqueId("");
    }

    public static String getUniqueId(String prefix) {
        return (prefix + UUID.randomUUID()).replaceAll("-", "_");
    }

    public static void sleep(long millis, String message) throws InterruptedException {
        Utils.sleep(millis, 5000, message);
    }

    public static void sleep(long millis, int interval, String message) throws InterruptedException {
        block1: {
            long t;
            long end = System.currentTimeMillis() + millis;
            while (true) {
                LOG.debug("{}", (Object)message);
                t = end - System.currentTimeMillis();
                if (t <= (long)interval) break;
                Thread.sleep(interval);
            }
            if (t <= 0L) break block1;
            Thread.sleep(t);
        }
    }

    public static String getKeepAliveFileName(String fileName) {
        return "lka_" + fileName;
    }

    public static File getKeepAliveFile(File file) {
        String name = Utils.getKeepAliveFileName(file.getName());
        return Paths.get(file.getParent(), name).toFile();
    }

    public static void cleanDirectory(String path, final float keepAliveHour, final String namePrefix) {
        long intervalMillis = 3600000L;
        final File dir = new File(path);
        if (!dir.exists()) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    long lastModifiedMillis = (long)((float)System.currentTimeMillis() - keepAliveHour * 3600000.0f);
                    Collection files = FileUtils.listFiles((File)dir, null, (boolean)true);
                    for (File file : files) {
                        if (file.lastModified() >= lastModifiedMillis || !file.getName().startsWith(namePrefix)) continue;
                        LOG.debug("Delete {}", (Object)file);
                        if (FileUtils.deleteQuietly((File)file)) continue;
                        LOG.debug("Cannot delete {}", (Object)file);
                    }
                    try {
                        LOG.debug("Waiting for next cleanup...");
                        Thread.sleep(3600000L);
                    }
                    catch (InterruptedException ex) {
                        LOG.warn(ex.getMessage());
                        return;
                    }
                }
            }
        };
        thread.setName(Thread.currentThread().getName() + "-cleaning-" + thread.hashCode());
        thread.setDaemon(true);
        LOG.debug("Starting directory cleaning thread (scanning hourly), all files/directories in {} and older than {} hour(s) and starts with {} will be deleted", new Object[]{dir, Float.valueOf(keepAliveHour), namePrefix});
        thread.start();
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.contains("Windows");
    }

    public static String buildClassPath(String[] paths) {
        String classPathDelimiter = Utils.isWindows() ? ";" : ":";
        return StringUtils.join((Object[])paths, (String)classPathDelimiter).replaceAll("\\\\", "/");
    }

    public static void captureScreen(File png) throws AWTException, IOException {
        Robot robot = new Robot();
        BufferedImage image = robot.createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
        ImageIO.write((RenderedImage)image, "png", png);
        LOG.debug("Save screenshot to {}", (Object)png.getAbsolutePath());
    }

    public static long getTime(String time, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date date = formatter.parse(time);
        return date.getTime();
    }

    public static void main(String[] args) throws Exception {
        List<String> ss = Utils.cmd(new String[]{"adb", "devices"});
        for (String s : ss) {
            LOG.debug("{}", (Object)s);
        }
        System.exit(0);
    }
}

