/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.comm;

import com.tascape.reactor.comm.EntityCommunication;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlCommunication
extends EntityCommunication {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlCommunication.class);
    public static final String TEMP_TABLE_NAME_SUFFIX = "_TEMP_TBL_SUFFIX";
    private final String dbUrl;
    private final String dbInfo;
    private final String user;
    private final String password;
    private boolean readOnly = false;
    private String schemaName;

    public MySqlCommunication(String dbUrl, String user, String password) {
        this.dbUrl = dbUrl;
        this.user = user;
        this.password = password;
        this.dbInfo = dbUrl.split("\\?")[0];
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public void disconnect() throws IOException {
    }

    /*
     * Exception decompiling
     */
    public boolean tableExists(String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String replicateTable(String tableName) throws SQLException {
        return this.replicateTable(tableName, true);
    }

    public String replicateTable(String tableName, boolean toCopyData) throws SQLException {
        String tempTableName = MySqlCommunication.getTempTableName(tableName);
        LOG.debug("Replicate table {} into {}", (Object)tableName, (Object)tempTableName);
        if (this.tableExists(tempTableName)) {
            this.truncateTempTable(tempTableName);
        } else {
            this.createTempTable(tableName);
        }
        if (toCopyData) {
            String sql = "INSERT INTO " + tempTableName + " SELECT * FROM " + tableName + ";";
            this.executeUpdate(sql);
        }
        return tempTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreTable(String tableName, String tempTableName) throws SQLException {
        LOG.debug("Restore table {} from {}", (Object)tableName, (Object)tempTableName);
        try {
            this.setForeignKeyCheckEnabled(false);
            this.truncateTable(tableName);
            String sql = "INSERT INTO " + tableName + " SELECT * FROM " + tempTableName + ";";
            this.executeUpdate(sql);
        }
        finally {
            this.setForeignKeyCheckEnabled(true);
        }
    }

    public void removeTempTable(String tempTableName) throws SQLException {
        if (tempTableName == null) {
            return;
        }
        if (!tempTableName.contains(TEMP_TABLE_NAME_SUFFIX)) {
            throw new SQLException(tempTableName + " is not a valid temp table name");
        }
        try (Connection conn = this.getConn();
             Statement stmt = conn.createStatement();){
            String sql = "DROP TABLE " + tempTableName + ";";
            LOG.debug("{} executing update: {}", (Object)this.dbInfo, (Object)sql);
            int n = stmt.executeUpdate(sql);
        }
    }

    public void createTempTable(String tableName) throws SQLException {
        String tempTableName = MySqlCommunication.getTempTableName(tableName);
        String sql = "CREATE TABLE " + tempTableName + " LIKE " + tableName + ";";
        this.executeUpdate(sql);
    }

    public void truncateTempTable(String tempTableName) throws SQLException {
        if (tempTableName == null) {
            return;
        }
        if (!tempTableName.contains(TEMP_TABLE_NAME_SUFFIX)) {
            throw new SQLException(tempTableName + " is not a valid temp table name");
        }
        this.truncateTable(tempTableName);
    }

    public void truncateTable(String tableName) throws SQLException {
        try (Connection conn = this.getConn();
             Statement stmt = conn.createStatement();){
            String sql = "TRUNCATE TABLE " + tableName + ";";
            LOG.debug("{} executing update: {}", (Object)this.dbInfo, (Object)sql);
            int n = stmt.executeUpdate(sql);
        }
    }

    public void renameTable(String tableNameOld, String tableNameNew) throws SQLException {
        try (Connection conn = this.getConn();
             Statement stmt = conn.createStatement();){
            String sql = "ALTER TABLE " + tableNameOld + " RENAME TO " + tableNameNew + ";";
            LOG.debug("{} executing update: {}", (Object)this.dbInfo, (Object)sql);
            int n = stmt.executeUpdate(sql);
        }
    }

    /*
     * Exception decompiling
     */
    public List<Map<String, Object>> dumpQueryResultSetToList(String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Map<String, Object>> dumpQueryResultSetToList(PreparedStatement stmt) throws SQLException {
        try (ResultSet rs = stmt.executeQuery();){
            LOG.debug("{} executing query: {}", (Object)this.dbInfo, (Object)this.getSql(stmt));
            List<Map<String, Object>> list = this.dumpQueryResultSetToList(rs);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateTempTable(String tempTableName, List<Map<String, Object>> rows) throws SQLException {
        if (tempTableName == null) {
            return;
        }
        if (!tempTableName.contains(TEMP_TABLE_NAME_SUFFIX)) {
            throw new SQLException(tempTableName + " is not a valid temp table name");
        }
        String sql = "SELECT * FROM " + tempTableName;
        try (Connection conn = this.getConn();
             Statement stmt = conn.createStatement(1005, 1008);){
            LOG.debug("{} executing query: {}", (Object)this.dbInfo, (Object)sql);
            ResultSet rs = stmt.executeQuery(sql);
            boolean autoCommit = conn.getAutoCommit();
            try {
                conn.setAutoCommit(false);
                int index = 0;
                for (Map<String, Object> row : rows) {
                    rs.moveToInsertRow();
                    for (String col : row.keySet()) {
                        rs.updateObject(col, row.get(col));
                    }
                    rs.insertRow();
                    rs.updateRow();
                    if (index++ % 200 != 0) continue;
                    conn.commit();
                }
                conn.commit();
            }
            finally {
                conn.setAutoCommit(autoCommit);
            }
        }
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.getConn().prepareStatement(sql, 1);
    }

    public PreparedStatement prepareUpdatableStatement(String sql) throws SQLException {
        return this.getConn().prepareStatement(sql, 1005, 1008);
    }

    public List<Map<String, Object>> executeUpdate(PreparedStatement stmt) throws SQLException {
        LOG.debug("{} executing update {}", (Object)this.dbInfo, (Object)this.getSql(stmt));
        if (this.readOnly) {
            throw new SQLException("Database is read only");
        }
        int rows = stmt.executeUpdate();
        LOG.debug("{} row{} affected", (Object)rows, (Object)(rows > 1 ? "s" : ""));
        try (ResultSet rs = stmt.getGeneratedKeys();){
            List<Map<String, Object>> list = this.dumpQueryResultSetToList(rs);
            return list;
        }
    }

    public void executeUpdate(String sql) throws SQLException {
        LOG.debug("{} executing update {}", (Object)this.dbInfo, (Object)sql);
        if (this.readOnly) {
            throw new SQLException("Database is read only");
        }
        try (Connection conn = this.getConn();
             Statement stmt = conn.createStatement();){
            int rows = stmt.executeUpdate(sql);
            LOG.debug("{} row{} affected", (Object)rows, (Object)(rows > 1 ? "s" : ""));
        }
    }

    public ResultSet executeQuery(PreparedStatement stmt) throws SQLException {
        LOG.debug("{} executing query {}", (Object)this.dbInfo, (Object)this.getSql(stmt));
        return stmt.executeQuery();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        LOG.debug("{} executing query {}", (Object)this.dbInfo, (Object)sql);
        Statement stmt = this.getConn().createStatement();
        return stmt.executeQuery(sql);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public static String getTempTableName(String tableName) {
        if (tableName.endsWith(TEMP_TABLE_NAME_SUFFIX)) {
            return tableName;
        }
        return tableName + TEMP_TABLE_NAME_SUFFIX;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    private Connection getConn() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("useJDBCCompliantTimezoneShift", "true");
        properties.setProperty("useLegacyDatetimeCode", "false");
        properties.setProperty("user", this.user);
        properties.setProperty("password", this.password);
        return DriverManager.getConnection(this.dbUrl, properties);
    }

    private List<Map<String, Object>> dumpQueryResultSetToList(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> rsml = new ArrayList<Map<String, Object>>();
        if (rs != null) {
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                LinkedHashMap<String, Object> d = new LinkedHashMap<String, Object>();
                for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                    d.put(rsmd.getColumnLabel(col), rs.getObject(col));
                }
                rsml.add(d);
            }
            LOG.trace("{} row{} loaded", (Object)rsml.size(), (Object)(rsml.size() > 1 ? "s" : ""));
        }
        return rsml;
    }

    private void setForeignKeyCheckEnabled(boolean enabled) throws SQLException {
        String sql = "SET GLOBAL FOREIGN_KEY_CHECKS = " + (enabled ? 1 : 0) + ";";
        this.executeUpdate(sql);
    }

    private String getSql(Statement stmt) {
        String sql = stmt.toString();
        int index = sql.indexOf(": ");
        index = index < 0 ? 0 : index + 2;
        return sql.substring(index);
    }

    static {
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException("Cannot load database driver", ex);
        }
    }
}

