/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.comm;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.tascape.reactor.SystemConfiguration;
import com.tascape.reactor.comm.EntityCommunication;
import com.tascape.reactor.exception.EntityCommunicationException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshCommunication
extends EntityCommunication
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SshCommunication.class);
    public static final String SYSPROP_HOST = "reactor.comm.ssh.HOST";
    public static final String SYSPROP_PORT = "reactor.comm.ssh.PORT";
    public static final String SYSPROP_KEY = "reactor.comm.ssh.KEY";
    public static final String SYSPROP_USER = "reactor.comm.ssh.USER";
    public static final String SYSPROP_PASS = "reactor.comm.ssh.PASS";
    private final JSch jSch;
    private final String host;
    private final int port;
    private Session session;
    private final Set<Channel> channels = new HashSet<Channel>();

    public static SshCommunication newInstance() throws Exception {
        return SshCommunication.newInstance("");
    }

    public static SshCommunication newInstance(String name) throws Exception {
        String pw;
        String k;
        int p;
        SystemConfiguration sysConfig = SystemConfiguration.getInstance();
        String h = sysConfig.getProperty(SYSPROP_HOST + name);
        if (h == null) {
            h = sysConfig.getProperty(SYSPROP_HOST, "localhost");
        }
        if ((p = sysConfig.getIntProperty(SYSPROP_PORT + name)) == Integer.MIN_VALUE) {
            p = sysConfig.getIntProperty(SYSPROP_PORT, 22);
        }
        SshCommunication ssh = new SshCommunication(h, p);
        String u = sysConfig.getProperty(SYSPROP_USER + name);
        if (u == null) {
            u = sysConfig.getProperty(SYSPROP_USER);
        }
        if ((k = sysConfig.getProperty(SYSPROP_KEY + name)) == null) {
            k = sysConfig.getProperty(SYSPROP_KEY);
        }
        if ((pw = sysConfig.getProperty(SYSPROP_PASS + name)) == null) {
            pw = sysConfig.getProperty(SYSPROP_PASS);
        }
        ssh.setPrivateKey(k, pw);
        ssh.setUsernamePassword(u, pw);
        ssh.connect();
        return ssh;
    }

    public SshCommunication(String host, int port) {
        this.jSch = new JSch();
        this.host = host;
        this.port = port;
    }

    public void setPrivateKey(String key, String passphrase) throws JSchException {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            this.jSch.addIdentity(key, passphrase);
        }
    }

    public void setUsernamePassword(String username, String password) throws JSchException {
        this.session = this.jSch.getSession(username, this.host, this.port);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        this.session.setPassword(password);
    }

    public List<String> shell(String command, long timeout) throws JSchException, IOException, Exception {
        Channel shell = this.session.openChannel("shell");
        shell.setInputStream(IOUtils.toInputStream((String)(command + "\nexit\n"), (Charset)Charset.defaultCharset()));
        try (BufferedReader in = new BufferedReader(new InputStreamReader(shell.getInputStream()));){
            shell.connect();
            this.channels.add(shell);
            ChanneOperationTimer thread = new ChanneOperationTimer(shell, timeout);
            thread.start();
            List<String> lines = in.lines().collect(Collectors.toList());
            thread.interrupt();
            lines.forEach(l -> LOG.debug("{}", l));
            List<String> list = lines;
            return list;
        }
    }

    public Channel shell(String command, OutputStream out) throws JSchException {
        Channel shell = this.session.openChannel("shell");
        shell.setInputStream(IOUtils.toInputStream((String)(command + "\nexit\n"), (Charset)Charset.defaultCharset()));
        shell.setOutputStream(out);
        shell.connect(2000);
        this.channels.add(shell);
        return shell;
    }

    public Channel shell(String command, File out) throws JSchException, IOException {
        Channel shell = this.session.openChannel("shell");
        shell.setInputStream(IOUtils.toInputStream((String)(command + "\nexit\n"), (Charset)Charset.defaultCharset()));
        shell.setOutputStream((OutputStream)FileUtils.openOutputStream((File)out));
        shell.connect();
        this.channels.add(shell);
        return shell;
    }

    public void upload(File srcFile, String destFile, long timeout) throws JSchException, SftpException, IOException {
        Channel channel = this.session.openChannel("sftp");
        channel.setInputStream(System.in);
        channel.setOutputStream((OutputStream)System.out);
        channel.connect();
        this.channels.add(channel);
        new ChanneOperationTimer(channel, timeout).start();
        ChannelSftp sftp = (ChannelSftp)channel;
        sftp.put((InputStream)FileUtils.openInputStream((File)srcFile), destFile);
        sftp.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String srcFile, File destFile, long timeout) throws JSchException, SftpException, IOException {
        Channel channel = this.session.openChannel("sftp");
        channel.setInputStream(System.in);
        channel.setOutputStream((OutputStream)System.out);
        channel.connect();
        this.channels.add(channel);
        new ChanneOperationTimer(channel, timeout).start();
        ChannelSftp sftp = (ChannelSftp)channel;
        try (FileOutputStream out = FileUtils.openOutputStream((File)destFile);){
            sftp.get(srcFile, (OutputStream)out);
        }
        finally {
            sftp.exit();
        }
    }

    @Override
    public void connect() throws Exception {
        this.session.connect();
        LOG.debug("connected to {}:{} ({})", new Object[]{this.session.getHost(), this.session.getPort(), this.session.getServerVersion()});
    }

    @Override
    public void disconnect() throws Exception {
        try {
            this.channels.forEach(c -> c.disconnect());
        }
        finally {
            if (this.session != null) {
                this.session.disconnect();
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.disconnect();
        }
        catch (Exception ex) {
            throw new EntityCommunicationException(ex);
        }
    }

    public static void main(String[] args) throws Exception {
        SystemConfiguration sys = SystemConfiguration.getInstance();
        sys.getProperties().setProperty(SYSPROP_HOST, "localhost");
        sys.getProperties().setProperty(SYSPROP_PORT, "2222");
        sys.getProperties().setProperty(SYSPROP_USER, "vagrant");
        sys.getProperties().setProperty(SYSPROP_PASS, "vagrant");
        SshCommunication ssh = SshCommunication.newInstance();
        SshCommunication.runSsh(ssh);
        ssh.disconnect();
        SshCommunication ssh2 = new SshCommunication("localhost", 2222);
        ssh2.setUsernamePassword("vagrant", "vagrant");
        ssh2.connect();
        SshCommunication.runSsh(ssh2);
        ssh2.disconnect();
        ssh2 = new SshCommunication("localhost", 2222);
        ssh2.setPrivateKey("~/.reactor/.vagrant/machines/default/virtualbox/private_key", "");
        ssh2.setUsernamePassword("vagrant", "");
        ssh2.connect();
        SshCommunication.runSsh(ssh2);
        ssh2.disconnect();
    }

    private static void runSsh(SshCommunication ssh) throws Exception {
        File out = File.createTempFile("ssh-", ".txt");
        FileUtils.write((File)out, (CharSequence)"ssh test", (Charset)Charset.defaultCharset());
        ssh.upload(out, "/home/vagrant/ssh.txt", 1000L);
        ssh.shell("ls -al && sleep 5", 6000L);
        ssh.shell("echo 'ssh' >> /home/vagrant/ssh.txt", 2000L);
        try (FileOutputStream os = FileUtils.openOutputStream((File)out);){
            ssh.shell("cat /home/vagrant/ssh.txt", os);
        }
        ssh.download("/home/vagrant/ssh.txt", out, 2000L);
        Thread.sleep(1000L);
    }

    private static class ChanneOperationTimer
    extends Thread {
        private final Channel channel;
        private final long timeout;

        public ChanneOperationTimer(Channel channel, long timeout) {
            this.channel = channel;
            this.timeout = timeout;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException ex) {
                LOG.trace("interrupted - {}", (Object)ex.getMessage());
            }
            if (this.channel != null) {
                this.channel.disconnect();
            }
        }
    }
}

