/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.data;

import com.tascape.reactor.data.CaseData;
import com.tascape.reactor.data.CaseDataInfo;
import com.tascape.reactor.task.AbstractCase;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCaseData
implements CaseData {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCaseData.class);
    private static final ThreadLocal<CaseData> CASE_DATA = new ThreadLocal();
    private static final Map<String, CaseData[]> LOADED_DATA = new HashMap<String, CaseData[]>();
    private static final Map<Class<? extends CaseData>, Object> LOADED_PROVIDERS = new HashMap<Class<? extends CaseData>, Object>();
    private String value = null;
    private String description = "";
    protected String externalId = "";
    protected AbstractCase kase;
    private int priority = 3;
    private boolean toBeImplemented = false;

    public static void setCaseData(CaseData data) {
        CASE_DATA.set(data);
    }

    public static CaseData getCaseData() {
        return CASE_DATA.get();
    }

    @Override
    public String getClassName() {
        return "";
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            LOG.warn("Value of case data is not specified.");
            return this.toString();
        }
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public CaseData setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public static CaseData getCaseData(String caseDataInfo) throws Exception {
        int index;
        CaseDataInfo info = new CaseDataInfo(caseDataInfo);
        CaseData[] data = AbstractCaseData.getCaseData(info.getKlass(), info.getMethod(), info.getParameter());
        if (data.length <= (index = info.getIndex())) {
            throw new Exception("Cannot find case data using " + caseDataInfo);
        }
        return data[index];
    }

    @Override
    public void setAbstractCase(AbstractCase kase) {
        this.kase = kase;
    }

    @Override
    public boolean isToBeImplemented() {
        return this.toBeImplemented;
    }

    public void markAsToBeImplemented() {
        this.toBeImplemented = true;
    }

    public static synchronized CaseData[] getCaseData(Class<? extends CaseData> klass, String method, String parameter) throws Exception {
        String key = klass + "." + method + "." + parameter;
        CaseData[] data = LOADED_DATA.get(key);
        if (data == null) {
            Object provider = LOADED_PROVIDERS.get(klass);
            if (provider == null) {
                provider = klass.newInstance();
                LOADED_PROVIDERS.put(klass, provider);
            }
            if (parameter == null || parameter.isEmpty()) {
                Method m = klass.getDeclaredMethod(method, null);
                data = (CaseData[])m.invoke(provider, (Object[])null);
            } else {
                Method m = klass.getDeclaredMethod(method, parameter.getClass());
                data = (CaseData[])m.invoke(provider, parameter);
            }
            LOADED_DATA.put(key, data);
        }
        return data;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AbstractCase getAbstractCase() {
        return this.kase;
    }
}

