/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.data;

import com.tascape.reactor.data.CaseData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseDataInfo {
    private static final Logger LOG = LoggerFactory.getLogger(CaseDataInfo.class);
    private static final Pattern pattern = Pattern.compile("([\\w\\.]+)\\.(\\w+?)\\((.*)\\)#(\\d+)");
    private static Map<String, Integer> dataSize = new HashMap<String, Integer>();
    private Class<? extends CaseData> klass;
    private String method;
    private String parameter;
    private int index;

    public CaseDataInfo(Class<? extends CaseData> klass, String method, String parameter, int index) {
        this.klass = klass;
        this.method = method;
        this.parameter = parameter;
        this.index = index;
        String key = klass + method + parameter;
        Integer size = dataSize.get(key);
        if (size == null || index > size) {
            dataSize.put(key, index);
        }
    }

    public CaseDataInfo(String infoString) throws ClassNotFoundException, IOException {
        Matcher m = pattern.matcher(infoString);
        if (!m.find()) {
            throw new IOException("Cannot parse case data info string " + infoString);
        }
        this.klass = Class.forName(m.group(1)).asSubclass(CaseData.class);
        this.method = m.group(2);
        this.parameter = m.group(3);
        this.index = Integer.parseInt(m.group(4));
    }

    Class<? extends CaseData> getKlass() {
        return this.klass;
    }

    String getMethod() {
        return this.method;
    }

    String getParameter() {
        return this.parameter;
    }

    int getIndex() {
        return this.index;
    }

    public String getIndexString() {
        int size = (dataSize.get(this.klass + this.method) + "").length();
        if (size == 0) {
            size = 1;
        }
        return String.format("%0" + size + "d", this.index);
    }

    public String format(int size) {
        String fmt = "%s.%s(%s)#%0" + size + "d";
        return String.format(fmt, this.klass.getName(), this.method, this.parameter, this.index);
    }
}

