/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.data;

import com.tascape.reactor.SystemConfiguration;
import com.tascape.reactor.data.AbstractCaseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseIterationData
extends AbstractCaseData {
    private static final Logger LOG = LoggerFactory.getLogger(CaseIterationData.class);
    public static final String USE_ITERATIONS = "useIterations";
    private int iteration = 1;
    private int iterations = 1;

    public CaseIterationData() {
    }

    private CaseIterationData(int iteration, int iterations) {
        this.iteration = iteration;
        this.iterations = iterations;
    }

    public CaseIterationData[] getData(String iterations) {
        return this.useIterations(iterations);
    }

    public CaseIterationData[] useIterations(String iterations) {
        int iters = 1;
        try {
            iters = Integer.parseInt(iterations);
        }
        catch (Exception ex) {
            LOG.warn(ex.getMessage());
        }
        CaseIterationData[] data = new CaseIterationData[iters];
        for (int i = 0; i < iters; ++i) {
            data[i] = new CaseIterationData(i, iters);
        }
        return data;
    }

    public CaseIterationData[] useSystemProperty(String sysPropIterations) {
        String n = SystemConfiguration.getInstance().getProperty(sysPropIterations);
        return this.useIterations(n);
    }

    @Override
    public String getValue() {
        int len = (this.iterations + "").length();
        return String.format("%0" + len + "d/%d", this.iteration + 1, this.iterations);
    }

    public int getIteration() {
        return this.iteration;
    }

    public int getIterations() {
        return this.iterations;
    }
}

