/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.db;

import com.tascape.reactor.ExecutionResult;
import com.tascape.reactor.Reactor;
import com.tascape.reactor.SystemConfiguration;
import com.tascape.reactor.TaskSuite;
import com.tascape.reactor.data.CaseIterationData;
import com.tascape.reactor.db.CaseResult;
import com.tascape.reactor.db.CaseResultMetric;
import com.tascape.reactor.db.H2Handler;
import com.tascape.reactor.db.MysqlHandler;
import com.tascape.reactor.db.PostgresqlHandler;
import com.tascape.reactor.db.SuiteProperty;
import com.tascape.reactor.db.SuiteResult;
import com.tascape.reactor.db.TaskCase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DbHandler.class);
    static final SystemConfiguration SYS_CONFIG = SystemConfiguration.getInstance();
    public static final String SYSPROP_DATABASE_TYPE = "reactor.db.type";
    public static final String SYSPROP_DATABASE_HOST = "reactor.db.host";
    public static final String SYSPROP_DATABASE_SCHEMA = "reactor.db.schema";
    public static final String SYSPROP_DATABASE_USER = "reactor.db.user";
    public static final String SYSPROP_DATABASE_PASS = "reactor.db.pass";
    public static final String SYSPROP_DATABASE_POOL_SIZE = "reactor.db.pool.size";

    public static DbHandler getInstance() {
        DbHandler dbh;
        String type;
        switch (type = SystemConfiguration.getInstance().getDatabaseType()) {
            case "h2": {
                dbh = new H2Handler();
                break;
            }
            case "postgresql": {
                dbh = new PostgresqlHandler();
                break;
            }
            case "mysql": {
                dbh = new MysqlHandler();
                break;
            }
            default: {
                dbh = new H2Handler();
            }
        }
        try {
            dbh.init();
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot connect to db", ex);
        }
        return dbh;
    }

    protected abstract void init() throws Exception;

    protected abstract Connection getConnection() throws SQLException;

    protected String getDbLock(String execId) {
        return Reactor.class.getName() + "." + execId;
    }

    public SuiteResult getSuiteResult(String id) throws SQLException {
        LOG.debug("Query for suite result with execution id {}", (Object)id);
        String sql = "SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?");
            stmt.setMaxRows(1);
            stmt.setString(1, id);
            ResultSet rs = stmt.executeQuery();
            SuiteResult tsr = new SuiteResult();
            if (rs.first()) {
                tsr.setSuiteResultId(rs.getString("SUITE_RESULT_ID"));
                tsr.setJobName(rs.getString("JOB_NAME"));
                tsr.setJobBuildNumber(rs.getInt("JOB_BUILD_NUMBER"));
                tsr.setJobBuildUrl(rs.getString("JOB_BUILD_URL"));
            } else {
                LOG.warn("no suite result with execution id {}", (Object)id);
            }
            SuiteResult suiteResult = tsr;
            return suiteResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSuiteExecution(TaskSuite suite, String execId) throws SQLException {
        LOG.debug("Queue case suite for execution with execution id {}", (Object)execId);
        String lock = this.getDbLock(execId);
        try (Connection conn = this.getConnection();){
            try {
                if (!this.acquireExecutionLock(conn, lock)) {
                    throw new SQLException("Cannot acquire lock of name " + lock);
                }
                if (this.queueTaskSuite(suite, execId)) {
                    this.queueCaseResults(execId, suite.getCases());
                }
            }
            finally {
                this.releaseExecutionLock(conn, lock);
            }
        }
    }

    public void setSuiteExecutionProperties(List<SuiteProperty> properties) throws SQLException {
        if (properties.isEmpty()) {
            return;
        }
        for (SuiteProperty prop : properties) {
            this.addSuiteExecutionProperty(prop);
        }
    }

    public void addSuiteExecutionProperty(SuiteProperty prop) throws SQLException {
        String sql = "INSERT INTO suite_property (SUITE_RESULT_ID, PROPERTY_NAME, PROPERTY_VALUE) VALUES (?,?,?)";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("INSERT INTO suite_property (SUITE_RESULT_ID, PROPERTY_NAME, PROPERTY_VALUE) VALUES (?,?,?)");
            stmt.setString(1, prop.getSuiteResultId());
            stmt.setString(2, StringUtils.left((String)prop.getPropertyName(), (int)255));
            stmt.setString(3, StringUtils.left((String)prop.getPropertyValue(), (int)255));
            stmt.executeUpdate();
        }
    }

    public abstract boolean queueTaskSuite(TaskSuite var1, String var2) throws SQLException;

    protected abstract int getCaseId(TaskCase var1) throws SQLException;

    protected Map<String, Integer> getCaseIds(List<TaskCase> cases) throws SQLException {
        HashSet suiteClasses = new HashSet();
        cases.stream().forEach(tc -> suiteClasses.add(tc.getSuiteClass()));
        HashMap<String, Integer> idMap = new HashMap<String, Integer>();
        String sql = "SELECT * FROM task_case WHERE ";
        String sql0 = "";
        sql0 = suiteClasses.stream().map(sc -> " OR SUITE_CLASS='" + sc + "'").reduce(sql0, String::concat);
        sql = sql + sql0.substring(4);
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(sql);
            LOG.debug("{}", (Object)stmt.toString());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                TaskCase tc2 = new TaskCase();
                tc2.setSuiteClass(rs.getString("SUITE_CLASS"));
                tc2.setCaseClass(rs.getString("CASE_CLASS"));
                tc2.setCaseMethod(rs.getString("CASE_METHOD"));
                tc2.setCaseDataInfo(rs.getString("CASE_DATA_INFO"));
                tc2.setCaseData(rs.getString("CASE_DATA"));
                idMap.put(tc2.format(), rs.getInt("TASK_CASE_ID"));
            }
            LOG.debug("Found {} cases exist", (Object)idMap.size());
            HashMap<String, Integer> hashMap = idMap;
            return hashMap;
        }
    }

    protected abstract void queueCaseResults(String var1, List<TaskCase> var2) throws SQLException;

    public List<CaseResult> getQueuedCaseResults(String execId, int limit) throws SQLException {
        LOG.debug("Query database for all queued cases");
        String sql = "SELECT * FROM case_result tr INNER JOIN task_case tc ON tr.TASK_CASE_ID=tc.TASK_CASE_ID AND EXECUTION_RESULT = ? WHERE SUITE_RESULT = ? ORDER BY SUITE_CLASS, CASE_CLASS, CASE_METHOD, CASE_DATA_INFO LIMIT ?;";
        ArrayList<CaseResult> tcrs = new ArrayList<CaseResult>();
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM case_result tr INNER JOIN task_case tc ON tr.TASK_CASE_ID=tc.TASK_CASE_ID AND EXECUTION_RESULT = ? WHERE SUITE_RESULT = ? ORDER BY SUITE_CLASS, CASE_CLASS, CASE_METHOD, CASE_DATA_INFO LIMIT ?;");
            stmt.setString(1, ExecutionResult.QUEUED.getName());
            stmt.setString(2, execId);
            stmt.setInt(3, limit);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                CaseResult tcr = new CaseResult();
                tcr.setCaseResultId(rs.getString("CASE_RESULT_ID"));
                tcr.setSuiteResultId(execId);
                tcr.setStartTime(rs.getLong("START_TIME"));
                tcr.setStopTime(rs.getLong("STOP_TIME"));
                tcr.setRetry(rs.getInt("RETRY"));
                TaskCase tc = new TaskCase();
                tc.setSuiteClass(rs.getString("SUITE_CLASS"));
                tc.setCaseClass(rs.getString("CASE_CLASS"));
                tc.setCaseMethod(rs.getString("CASE_METHOD"));
                tc.setCaseDataInfo(rs.getString("CASE_DATA_INFO"));
                tc.setCaseData(rs.getString("CASE_DATA"));
                tcr.setTaskCase(tc);
                tcr.setCaseStation(rs.getString("CASE_STATION"));
                tcr.setCaseEnv(rs.getString("CASE_ENV"));
                tcr.setLogDir(rs.getString("LOG_DIR"));
                tcr.setExternalId(rs.getString("EXTERNAL_ID"));
                tcrs.add(tcr);
            }
        }
        int num = tcrs.size();
        LOG.debug("Found {} case{} in DB with QUEUED state", (Object)num, (Object)(num > 1 ? "s" : ""));
        return tcrs;
    }

    public boolean acquireCaseResult(CaseResult tcr) throws SQLException {
        LOG.debug("Try to acquire case {}", (Object)tcr.getTaskCase().format());
        String sql = "SELECT * FROM case_result WHERE CASE_RESULT_ID = ? LIMIT 1;";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM case_result WHERE CASE_RESULT_ID = ? LIMIT 1;", 1005, 1008);
            stmt.setString(1, tcr.getCaseResultId());
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String host = rs.getString("CASE_STATION");
                if (rs.getString("EXECUTION_RESULT").equals(ExecutionResult.QUEUED.result())) {
                    LOG.debug("Found case {} in DB with QUEUED state", (Object)tcr.getTaskCase().format());
                    rs.updateString("EXECUTION_RESULT", ExecutionResult.ACQUIRED.result());
                    rs.updateString("CASE_STATION", SYS_CONFIG.getHostName());
                    rs.updateRow();
                    boolean bl = true;
                    return bl;
                }
                LOG.debug("Csase {} was acquired by {}", (Object)tcr.getTaskCase().format(), (Object)host);
            }
        }
        return false;
    }

    public void updateSuiteProductUnderTask(String execId, String productUnderTask) throws SQLException {
        if (StringUtils.isBlank((CharSequence)productUnderTask)) {
            return;
        }
        String sql = "SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?;";
        try (PreparedStatement stmt = this.getConnection().prepareStatement("SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?;", 1005, 1008);){
            stmt.setString(1, execId);
            ResultSet rs = stmt.executeQuery();
            if (rs.first()) {
                if (StringUtils.isBlank((CharSequence)rs.getString("PRODUCT_UNDER_TASK"))) {
                    rs.updateString("PRODUCT_UNDER_TASK", productUnderTask);
                }
                rs.updateRow();
            }
        }
    }

    public void updateCaseExecutionResult(CaseResult tcr) throws SQLException {
        LOG.trace("Update case result {} ({}) to {}", new Object[]{tcr.getCaseResultId(), tcr.getTaskCase().format(), tcr.getResult().result()});
        String sql = "SELECT tr.* FROM case_result tr INNER JOIN task_case tc WHERE tr.TASK_CASE_ID=tc.TASK_CASE_ID AND CASE_RESULT_ID = ?;";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("SELECT tr.* FROM case_result tr INNER JOIN task_case tc WHERE tr.TASK_CASE_ID=tc.TASK_CASE_ID AND CASE_RESULT_ID = ?;", 1005, 1008);
            stmt.setString(1, tcr.getCaseResultId());
            ResultSet rs = stmt.executeQuery();
            if (rs.first()) {
                rs.updateString("EXECUTION_RESULT", tcr.getResult().result());
                rs.updateString("AUT", tcr.getAut());
                rs.updateLong("START_TIME", (long)tcr.getStartTime());
                rs.updateLong("STOP_TIME", (long)tcr.getStopTime());
                rs.updateInt("RETRY", (int)tcr.getRetry());
                rs.updateString("CASE_STATION", tcr.getCaseStation());
                rs.updateString("CASE_ENV", tcr.getCaseEnv());
                rs.updateString("LOG_DIR", tcr.getLogDir());
                rs.updateString("EXTERNAL_ID", tcr.getExternalId());
                rs.updateRow();
            } else {
                LOG.warn("Cannot update case result");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult updateSuiteExecutionResult(String execId) throws SQLException {
        LOG.debug("Update suite execution result with execution id {}", (Object)execId);
        String lock = this.getDbLock(execId);
        ExecutionResult suiteResult = ExecutionResult.newMultiple();
        int total = 0;
        int fail = 0;
        try (Connection conn = this.getConnection();){
            try {
                ResultSet rs;
                if (!this.acquireExecutionLock(conn, lock)) {
                    throw new SQLException("Cannot acquire lock of name " + lock);
                }
                String sql1 = "SELECT EXECUTION_RESULT FROM case_result WHERE SUITE_RESULT = ?;";
                try (PreparedStatement stmt = this.getConnection().prepareStatement("SELECT EXECUTION_RESULT FROM case_result WHERE SUITE_RESULT = ?;", 1003, 1007);){
                    stmt.setString(1, execId);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String result = rs.getString("EXECUTION_RESULT");
                        String[] pf = result.split("/");
                        if (pf.length == 1) {
                            ++total;
                            if (result.equals(ExecutionResult.PASS.getName())) continue;
                            ++fail;
                            continue;
                        }
                        if (pf.length == 2) {
                            int p = Integer.parseInt(pf[0]);
                            int f = Integer.parseInt(pf[1]);
                            total += p + f;
                            fail += f;
                            continue;
                        }
                        throw new RuntimeException("Cannot parse case execution result " + result);
                    }
                }
                String sql = "SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?;";
                stmt = this.getConnection().prepareStatement("SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?;", 1005, 1008);
                var10_12 = null;
                try {
                    stmt.setString(1, execId);
                    rs = stmt.executeQuery();
                    if (rs.first()) {
                        rs.updateInt("NUMBER_OF_CASES", total);
                        rs.updateInt("NUMBER_OF_FAILURE", fail);
                        rs.updateString("EXECUTION_RESULT", fail == 0 ? "PASS" : "FAIL");
                        rs.updateLong("STOP_TIME", System.currentTimeMillis());
                        rs.updateRow();
                        suiteResult.setPass(total - fail);
                        suiteResult.setFail(fail);
                    }
                }
                catch (Throwable throwable) {
                    var10_12 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var10_12 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var10_12.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            finally {
                this.releaseExecutionLock(conn, lock);
            }
        }
        return suiteResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult adjustSuiteExecutionResult(String execId) throws SQLException {
        LOG.debug("Adjust suite execution result of execution id {} with iterations and TBI", (Object)execId);
        String lock = this.getDbLock(execId);
        ExecutionResult suiteResult = ExecutionResult.newMultiple();
        int total = 0;
        int fail = 0;
        try (Connection conn = this.getConnection();){
            try {
                if (!this.acquireExecutionLock(conn, lock)) {
                    throw new SQLException("Cannot acquire lock of name " + lock);
                }
                String iterDataInfo = CaseIterationData.class.getName();
                HashMap<String, Boolean> iterationCases = new HashMap<String, Boolean>();
                String sql = "SELECT tr.*, tc.* FROM case_result tr JOIN task_case tc ON tr.TASK_CASE_ID = tc.TASK_CASE_ID WHERE SUITE_RESULT = ? ORDER BY tr.START_TIME DESC;";
                try (PreparedStatement stmt = this.getConnection().prepareStatement(sql);){
                    stmt.setString(1, execId);
                    LOG.debug("{}", (Object)stmt);
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        LOG.trace("{}.{}", (Object)rs.getString("CASE_CLASS"), (Object)rs.getString("CASE_METHOD"));
                        String result = rs.getString("EXECUTION_RESULT");
                        if (result.equals(ExecutionResult.TBI.getName())) {
                            LOG.warn("skip TBI case {}.{}", (Object)rs.getString("CASE_CLASS"), (Object)rs.getString("CASE_METHOD"));
                            continue;
                        }
                        int p = 0;
                        int f = 0;
                        String[] pf = result.split("/");
                        switch (pf.length) {
                            case 1: {
                                if (ExecutionResult.isPass(result)) {
                                    p = 1;
                                    break;
                                }
                                f = 1;
                                break;
                            }
                            case 2: {
                                p = Integer.parseInt(pf[0]);
                                f = Integer.parseInt(pf[1]);
                                break;
                            }
                            default: {
                                throw new RuntimeException("Cannot parse case execution result " + result);
                            }
                        }
                        if (rs.getString("CASE_DATA_INFO").startsWith(iterDataInfo)) {
                            String key = rs.getString("SUITE_CLASS") + rs.getString("CASE_CLASS") + rs.getString("CASE_METHOD");
                            LOG.debug("aggregate result of run iterations {}", (Object)key);
                            Boolean r = (Boolean)iterationCases.get(key);
                            if (r == null) {
                                iterationCases.put(key, f > 0 ? Boolean.FALSE : Boolean.TRUE);
                                continue;
                            }
                            iterationCases.put(key, f > 0 ? Boolean.FALSE : r);
                            continue;
                        }
                        LOG.trace("total {}, fail {}", (Object)(total += p + f), (Object)(fail += f));
                    }
                    LOG.debug("{} {}", (Object)total, (Object)fail);
                }
                fail = (int)((long)fail + iterationCases.values().stream().filter(v -> v.equals(Boolean.FALSE)).count());
                LOG.debug("{} {}", (Object)(total += iterationCases.size()), (Object)fail);
                suiteResult.setFail(fail);
                suiteResult.setPass(total - fail);
                String sql2 = "SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?;";
                try (PreparedStatement stmt = this.getConnection().prepareStatement("SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?;", 1005, 1008);){
                    stmt.setString(1, execId);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.first()) {
                        rs.updateInt("NUMBER_OF_CASES", total);
                        rs.updateInt("NUMBER_OF_FAILURE", fail);
                        rs.updateString("EXECUTION_RESULT", fail == 0 ? "PASS" : "FAIL");
                        rs.updateRow();
                    }
                }
            }
            finally {
                this.releaseExecutionLock(conn, lock);
            }
        }
        return suiteResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteSuiteExecutionResult(String execId, ExecutionResult result) throws SQLException {
        LOG.debug("Overwrite suite execution result with execution id {} with {}", (Object)execId, (Object)result);
        int total = result.getPass() + result.getFail();
        if (total == 0) {
            return;
        }
        int fail = result.getFail();
        String lock = this.getDbLock(execId);
        try (Connection conn = this.getConnection();){
            try {
                if (!this.acquireExecutionLock(conn, lock)) {
                    throw new SQLException("Cannot acquire lock of name " + lock);
                }
                String sql = "SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?;";
                try (PreparedStatement stmt = this.getConnection().prepareStatement("SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?;", 1005, 1008);){
                    stmt.setString(1, execId);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.first()) {
                        rs.updateInt("NUMBER_OF_CASES", total);
                        rs.updateInt("NUMBER_OF_FAILURE", fail);
                        rs.updateString("EXECUTION_RESULT", fail == 0 ? "PASS" : "FAIL");
                        rs.updateRow();
                    }
                }
            }
            finally {
                this.releaseExecutionLock(conn, lock);
            }
        }
    }

    public void saveJunitXml(String execId) throws IOException, SQLException, XMLStreamException {
        block52: {
            Path path = SYS_CONFIG.getLogPath().resolve(execId).resolve("result.xml");
            Path html = SYS_CONFIG.getLogPath().resolve(execId).resolve("result.html");
            LOG.debug("Generate JUnit XML result");
            String sql = "SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?;";
            try (PreparedStatement stmt = this.getConnection().prepareStatement("SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?;");){
                stmt.setString(1, execId);
                ResultSet rs = stmt.executeQuery();
                if (rs.first()) {
                    try (FileOutputStream os = new FileOutputStream(path.toFile());
                         PrintWriter pwh = new PrintWriter(html.toFile());){
                        XMLStreamWriter xsw = XMLOutputFactory.newInstance().createXMLStreamWriter(os);
                        xsw.writeStartDocument();
                        xsw.writeCharacters("\n");
                        xsw.writeStartElement("testsuite");
                        xsw.writeAttribute("name", rs.getString("SUITE_NAME"));
                        xsw.writeAttribute("projectname", rs.getString("PROJECT_NAME") + "");
                        xsw.writeAttribute("tests", rs.getInt("NUMBER_OF_CASES") + "");
                        xsw.writeAttribute("failures", rs.getInt("NUMBER_OF_FAILURE") + "");
                        xsw.writeAttribute("time", (double)(rs.getLong("STOP_TIME") - rs.getLong("START_TIME")) / 1000.0 + "");
                        xsw.writeAttribute("srid", rs.getString("SUITE_RESULT_ID"));
                        xsw.writeCharacters("\n");
                        pwh.println("<html><head><style>");
                        pwh.println("body {font-family: Consolas,Monaco,Lucida Console,Liberation Mono,DejaVu Sans Mono,Bitstream Vera Sans Mono,Courier New, monospace;}");
                        pwh.println("tr:hover {background-color: lightgray;}");
                        pwh.println("td {padding-left: 20px; padding-right: 20px;}");
                        pwh.println("</style></head<body>");
                        pwh.printf("<h2>%s</h2>", rs.getString("SUITE_NAME"));
                        pwh.printf("<h3>%s</h3>", rs.getString("PROJECT_NAME"));
                        pwh.printf("<h4>casess %d, failures %d</h4>", rs.getInt("NUMBER_OF_CASES"), rs.getInt("NUMBER_OF_FAILURE"));
                        pwh.println("<table><thead><tr><th>index</th><th>case</th><th>result</th></thead><tbody>");
                        String sql1 = "SELECT * FROM case_result tr JOIN task_case tc ON tr.TASK_CASE_ID = tc.TASK_CASE_ID WHERE SUITE_RESULT = ?;";
                        try (PreparedStatement stmt1 = this.getConnection().prepareStatement("SELECT * FROM case_result tr JOIN task_case tc ON tr.TASK_CASE_ID = tc.TASK_CASE_ID WHERE SUITE_RESULT = ?;");){
                            stmt1.setString(1, execId);
                            ResultSet rs1 = stmt1.executeQuery();
                            int i = 0;
                            while (rs1.next()) {
                                String result = rs1.getString("EXECUTION_RESULT");
                                xsw.writeCharacters("  ");
                                xsw.writeStartElement("testcase");
                                xsw.writeAttribute("name", rs1.getString("CASE_METHOD") + "(" + rs1.getString("CASE_DATA") + ")");
                                xsw.writeAttribute("classname", rs1.getString("CASE_CLASS"));
                                xsw.writeAttribute("result", result);
                                xsw.writeAttribute("time", (double)(rs1.getLong("STOP_TIME") - rs1.getLong("START_TIME")) / 1000.0 + "");
                                if (!ExecutionResult.isPass(result)) {
                                    xsw.writeStartElement("failure");
                                    xsw.writeAttribute("type", "failure");
                                    xsw.writeEndElement();
                                    xsw.writeCharacters("\n");
                                }
                                xsw.writeEndElement();
                                xsw.writeCharacters("\n");
                                String l = rs1.getString("LOG_DIR");
                                String r = rs1.getString("EXECUTION_RESULT");
                                pwh.printf("<tr><td>%d</td><td>%s</td><td><a style='color: %s; font-weight: bold' href='%s/log.html' target='_blank'>%s</a></td></tr>", ++i, rs1.getString("CASE_METHOD") + "(" + rs1.getString("CASE_DATA") + ")", r.equals("PASS") || r.endsWith("/0") ? "green" : "red", l, r);
                            }
                        }
                        pwh.println("</tbody></table></body></html>");
                        xsw.writeEndElement();
                        xsw.writeCharacters("\n");
                        xsw.writeEndDocument();
                        xsw.close();
                        break block52;
                    }
                }
                LOG.error("No suite result of exec id {}", (Object)execId);
            }
        }
    }

    public void exportToJson(String execId) throws IOException, SQLException, XMLStreamException {
        List<Map<String, Object>> l3;
        Throwable throwable;
        PreparedStatement stmt4;
        List<Map<String, Object>> metrics;
        Object l22;
        Throwable throwable2;
        Object stmt2;
        Path path = SYS_CONFIG.getLogPath().resolve(execId).resolve("result.json");
        LOG.debug("Generate JSON result");
        JSONObject sr = new JSONObject();
        String sql = "SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?;";
        try (Connection conn = this.getConnection();){
            stmt2 = conn.prepareStatement("SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?;");
            throwable2 = null;
            try {
                stmt2.setString(1, execId);
                l22 = DbHandler.dumpResultSetToList(stmt2.executeQuery());
                if (l22.isEmpty()) {
                    LOG.error("No suite result of exec id {}", (Object)execId);
                }
                Map<String, Object> r = l22.get(0);
                r.entrySet().forEach(entry -> sr.put((String)entry.getKey(), entry.getValue()));
            }
            catch (Throwable l22) {
                throwable2 = l22;
                throw l22;
            }
            finally {
                if (stmt2 != null) {
                    if (throwable2 != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable l22) {
                            throwable2.addSuppressed(l22);
                        }
                    } else {
                        stmt2.close();
                    }
                }
            }
        }
        String sql2 = "SELECT trm.* FROM case_result_metric trm JOIN case_result tr ON trm.CASE_RESULT_ID = tr.CASE_RESULT_ID WHERE SUITE_RESULT = ?;";
        Connection conn = this.getConnection();
        stmt2 = null;
        try {
            PreparedStatement stmt3 = conn.prepareStatement("SELECT trm.* FROM case_result_metric trm JOIN case_result tr ON trm.CASE_RESULT_ID = tr.CASE_RESULT_ID WHERE SUITE_RESULT = ?;");
            l22 = null;
            try {
                stmt3.setString(1, execId);
                metrics = DbHandler.dumpResultSetToList(stmt3.executeQuery());
            }
            catch (Throwable throwable3) {
                l22 = throwable3;
                throw throwable3;
            }
            finally {
                if (stmt3 != null) {
                    if (l22 != null) {
                        try {
                            stmt3.close();
                        }
                        catch (Throwable throwable4) {
                            ((Throwable)l22).addSuppressed(throwable4);
                        }
                    } else {
                        stmt3.close();
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            stmt2 = throwable5;
            throw throwable5;
        }
        finally {
            if (conn != null) {
                if (stmt2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable6) {
                        ((Throwable)stmt2).addSuppressed(throwable6);
                    }
                } else {
                    conn.close();
                }
            }
        }
        JSONArray trs = new JSONArray();
        String sql3 = "SELECT * FROM case_result tr JOIN task_case tc ON tr.TASK_CASE_ID = tc.TASK_CASE_ID WHERE SUITE_RESULT = ?;";
        throwable2 = null;
        try (Connection conn2 = this.getConnection();){
            stmt4 = conn2.prepareStatement("SELECT * FROM case_result tr JOIN task_case tc ON tr.TASK_CASE_ID = tc.TASK_CASE_ID WHERE SUITE_RESULT = ?;");
            throwable = null;
            try {
                stmt4.setString(1, execId);
                l3 = DbHandler.dumpResultSetToList(stmt4.executeQuery());
                l3.forEach(row -> {
                    JSONObject j = new JSONObject();
                    row.entrySet().forEach(col -> j.put((String)col.getKey(), col.getValue()));
                    trs.put(trs.length(), (Object)j);
                    JSONArray trms = new JSONArray();
                    metrics.stream().filter(r -> j.getString("CASE_RESULT_ID").equals(r.get("CASE_RESULT_ID"))).forEach(r -> {
                        JSONObject jm = new JSONObject();
                        r.entrySet().forEach(c -> jm.put((String)c.getKey(), c.getValue()));
                        trms.put((Object)jm);
                    });
                    j.put("case_result_metrics", (Object)trms);
                });
            }
            catch (Throwable l3) {
                throwable = l3;
                throw l3;
            }
            finally {
                if (stmt4 != null) {
                    if (throwable != null) {
                        try {
                            stmt4.close();
                        }
                        catch (Throwable l3) {
                            throwable.addSuppressed(l3);
                        }
                    } else {
                        stmt4.close();
                    }
                }
            }
        }
        catch (Throwable stmt4) {
            throwable2 = stmt4;
            throw stmt4;
        }
        sr.put("case_results", (Object)trs);
        JSONArray sps = new JSONArray();
        sql3 = "SELECT * FROM suite_property WHERE SUITE_RESULT_ID = ?;";
        conn2 = this.getConnection();
        throwable2 = null;
        try {
            stmt4 = conn2.prepareStatement("SELECT * FROM suite_property WHERE SUITE_RESULT_ID = ?;");
            throwable = null;
            try {
                stmt4.setString(1, execId);
                l3 = DbHandler.dumpResultSetToList(stmt4.executeQuery());
                l3.forEach(row -> {
                    JSONObject j = new JSONObject();
                    row.entrySet().forEach(col -> j.put((String)col.getKey(), col.getValue()));
                    sps.put(sps.length(), (Object)j);
                });
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (stmt4 != null) {
                    if (throwable != null) {
                        try {
                            stmt4.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        stmt4.close();
                    }
                }
            }
        }
        catch (Throwable throwable9) {
            throwable2 = throwable9;
            throw throwable9;
        }
        finally {
            if (conn2 != null) {
                if (throwable2 != null) {
                    try {
                        conn2.close();
                    }
                    catch (Throwable throwable10) {
                        throwable2.addSuppressed(throwable10);
                    }
                } else {
                    conn2.close();
                }
            }
        }
        sr.put("suite_properties", (Object)sps);
        FileUtils.write((File)path.toFile(), (CharSequence)new JSONObject().put("suite_result", (Object)sr).toString(2), (Charset)Charset.defaultCharset());
    }

    public void importFromJson(String json) throws SQLException {
        PreparedStatement stmt;
        String sql;
        JSONObject j = new JSONObject(json);
        JSONObject sr = j.getJSONObject("suite_result");
        String srid = sr.getString("SUITE_RESULT_ID");
        LOG.debug("srid {}", (Object)srid);
        try (Connection conn = this.getConnection();){
            String sql2 = "SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?;";
            PreparedStatement stmt2 = conn.prepareStatement(sql2, 1005, 1008);
            stmt2.setString(1, srid);
            ResultSet rs = stmt2.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            if (rs.first()) {
                LOG.debug("already imported {}", (Object)srid);
                return;
            }
            rs.moveToInsertRow();
            for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                String cn = rsmd.getColumnLabel(col);
                rs.updateObject(cn, sr.get(cn));
            }
            rs.insertRow();
            rs.last();
            rs.updateRow();
        }
        LOG.debug("sr imported");
        JSONArray trs = sr.getJSONArray("case_results");
        int len = trs.length();
        try (Connection conn = this.getConnection();){
            sql = String.format("SELECT * FROM %s WHERE %s=? AND %s=? AND %s=? AND %s=? AND %s=?;", "task_case", "SUITE_CLASS", "CASE_CLASS", "CASE_METHOD", "CASE_DATA_INFO", "CASE_DATA");
            stmt = conn.prepareStatement(sql, 1005, 1008);
            stmt.setMaxRows(1);
            for (int i = 0; i < len; ++i) {
                JSONObject tr = trs.getJSONObject(i);
                stmt.setString(1, tr.getString("SUITE_CLASS"));
                stmt.setString(2, tr.getString("CASE_CLASS"));
                stmt.setString(3, tr.getString("CASE_METHOD"));
                stmt.setString(4, tr.getString("CASE_DATA_INFO"));
                stmt.setString(5, tr.getString("CASE_DATA"));
                ResultSet rs = stmt.executeQuery();
                if (!rs.first()) {
                    rs.moveToInsertRow();
                    rs.updateString("SUITE_CLASS", tr.getString("SUITE_CLASS"));
                    rs.updateString("CASE_CLASS", tr.getString("CASE_CLASS"));
                    rs.updateString("CASE_METHOD", tr.getString("CASE_METHOD"));
                    rs.updateString("CASE_DATA_INFO", tr.getString("CASE_DATA_INFO"));
                    rs.updateString("CASE_DATA", tr.getString("CASE_DATA"));
                    rs.insertRow();
                    rs.last();
                    rs.updateRow();
                    rs = stmt.executeQuery();
                    rs.first();
                }
                tr.put("TASK_CASE_ID", rs.getLong("TASK_CASE_ID"));
            }
        }
        LOG.debug("tcid updated");
        conn = this.getConnection();
        var8_11 = null;
        try {
            sql = "SELECT * FROM case_result WHERE SUITE_RESULT = ?;";
            stmt = conn.prepareStatement(sql, 1005, 1008);
            stmt.setString(1, srid);
            ResultSet rs = stmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 0; i < len; ++i) {
                rs.moveToInsertRow();
                JSONObject tr = trs.getJSONObject(i);
                for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                    String cn = rsmd.getColumnLabel(col);
                    rs.updateObject(cn, tr.get(cn));
                }
                rs.insertRow();
                rs.last();
                rs.updateRow();
            }
        }
        catch (Throwable throwable) {
            var8_11 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var8_11 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var8_11.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        LOG.debug("trs imported");
    }

    public void saveCaseResultMetrics(String trid, List<CaseResultMetric> resultMetrics) throws SQLException {
        if (resultMetrics.isEmpty()) {
            return;
        }
        String sql = "INSERT INTO case_result_metric (CASE_RESULT_ID, METRIC_GROUP, METRIC_NAME, METRIC_VALUE) VALUES (?,?,?,?)";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("INSERT INTO case_result_metric (CASE_RESULT_ID, METRIC_GROUP, METRIC_NAME, METRIC_VALUE) VALUES (?,?,?,?)");
            LOG.trace("save metric data for {}", (Object)trid);
            for (CaseResultMetric metric : resultMetrics) {
                stmt.setString(1, trid);
                stmt.setString(2, metric.getMetricGroup());
                stmt.setString(3, metric.getMetricName());
                stmt.setDouble(4, metric.getMetricValue());
                stmt.executeUpdate();
            }
        }
    }

    public static List<Map<String, Object>> dumpResultSetToList(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> rsml = new ArrayList<Map<String, Object>>();
        ResultSetMetaData rsmd = rs.getMetaData();
        while (rs.next()) {
            LinkedHashMap<String, Object> d = new LinkedHashMap<String, Object>();
            for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                d.put(rsmd.getColumnLabel(col), rs.getObject(col));
            }
            rsml.add(d);
        }
        LOG.trace("{} rows loaded", (Object)rsml.size());
        return rsml;
    }

    protected int hash(String string) {
        char[] chars = string.toCharArray();
        int hash = 7;
        for (int i = 0; i < chars.length; ++i) {
            hash = hash * 31 + chars[i];
        }
        return hash;
    }

    protected abstract boolean acquireExecutionLock(Connection var1, String var2) throws SQLException;

    protected abstract boolean releaseExecutionLock(Connection var1, String var2) throws SQLException;

    public static void main(String[] args) throws Exception {
        SystemConfiguration.getInstance();
        DbHandler db = DbHandler.getInstance();
        db.adjustSuiteExecutionResult("th_f592936e_69b7_46eb_9c76_eaed9bbbeea3");
    }
}

