/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.db;

import com.tascape.reactor.ExecutionResult;
import com.tascape.reactor.TaskSuite;
import com.tascape.reactor.Utils;
import com.tascape.reactor.db.DbHandler;
import com.tascape.reactor.db.ScriptRunner;
import com.tascape.reactor.db.TaskCase;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.h2.jdbcx.JdbcConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class H2Handler
extends DbHandler {
    private static final Logger LOG = LoggerFactory.getLogger(H2Handler.class);
    private static final String DB_DRIVER = "org.h2.Driver";
    private final String dbPath = SYS_CONFIG.getLogPath() + "/db/" + "lka_" + System.currentTimeMillis() + "/";
    private JdbcConnectionPool connPool;

    @Override
    public void init() throws Exception {
        File dir = new File(this.dbPath);
        if (dir.exists()) {
            FileUtils.cleanDirectory((File)dir);
        }
        this.connPool = JdbcConnectionPool.create((String)("jdbc:h2:" + this.dbPath + SYS_CONFIG.getExecId()), (String)"sa", (String)"sa");
        this.connPool.setMaxConnections(Integer.MAX_VALUE);
        try (Connection conn = this.getConnection();){
            try {
                conn.prepareStatement("SELECT * FROM case_result WHERE 0;").executeQuery();
            }
            catch (SQLException ex) {
                LOG.warn("{}", (Object)ex.getMessage());
                this.initSchema();
            }
        }
    }

    @Override
    public boolean queueTaskSuite(TaskSuite suite, String execId) throws SQLException {
        LOG.debug("Queueing suite result with execution id {} ", (Object)execId);
        String sql = "INSERT INTO suite_result (SUITE_RESULT_ID, SUITE_NAME, PROJECT_NAME, JOB_NAME, JOB_BUILD_NUMBER, JOB_BUILD_URL, START_TIME, STOP_TIME, EXECUTION_RESULT, NUMBER_OF_CASES, NUMBER_OF_FAILURE, PRODUCT_UNDER_TASK) VALUES (?,?,?,?,?,?,?,?,?,?,?,?);";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("INSERT INTO suite_result (SUITE_RESULT_ID, SUITE_NAME, PROJECT_NAME, JOB_NAME, JOB_BUILD_NUMBER, JOB_BUILD_URL, START_TIME, STOP_TIME, EXECUTION_RESULT, NUMBER_OF_CASES, NUMBER_OF_FAILURE, PRODUCT_UNDER_TASK) VALUES (?,?,?,?,?,?,?,?,?,?,?,?);");
            Long time = System.currentTimeMillis();
            stmt.setString(1, execId);
            stmt.setString(2, suite.getName());
            stmt.setString(3, suite.getProjectName());
            stmt.setString(4, SYS_CONFIG.getJobName());
            stmt.setInt(5, SYS_CONFIG.getJobBuildNumber());
            stmt.setString(6, SYS_CONFIG.getJobBuildUrl());
            stmt.setLong(7, time);
            stmt.setLong(8, time + 11L);
            stmt.setString(9, ExecutionResult.QUEUED.getName());
            stmt.setInt(10, suite.getCases().size());
            stmt.setInt(11, suite.getCases().size());
            stmt.setString(12, SYS_CONFIG.getProdUnderTask());
            LOG.debug("{}", (Object)stmt);
            int i = stmt.executeUpdate();
            boolean bl = i == 1;
            return bl;
        }
    }

    @Override
    protected void queueCaseResults(String execId, List<TaskCase> cases) throws SQLException {
        LOG.debug("Queue {} case result(s) with execution id {} ", (Object)cases.size(), (Object)execId);
        String sql = "INSERT INTO case_result (CASE_RESULT_ID, SUITE_RESULT, TASK_CASE_ID, EXECUTION_RESULT, START_TIME, STOP_TIME, CASE_STATION, CASE_ENV, LOG_DIR, RETRY) VALUES (?,?,?,?,?,?,?,?,?,?);";
        Map<String, Integer> idMap = this.getCaseIds(cases);
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("INSERT INTO case_result (CASE_RESULT_ID, SUITE_RESULT, TASK_CASE_ID, EXECUTION_RESULT, START_TIME, STOP_TIME, CASE_STATION, CASE_ENV, LOG_DIR, RETRY) VALUES (?,?,?,?,?,?,?,?,?,?);");
            boolean index = false;
            for (TaskCase kase : cases) {
                Integer tcid = idMap.get(kase.format());
                if (tcid == null) {
                    tcid = this.getCaseId(kase);
                }
                Long time = System.currentTimeMillis();
                stmt.setString(1, Utils.getUniqueId());
                stmt.setString(2, execId);
                stmt.setInt(3, tcid);
                stmt.setString(4, ExecutionResult.QUEUED.getName());
                stmt.setLong(5, time);
                stmt.setLong(6, time + 11L);
                stmt.setString(7, "?");
                stmt.setString(8, "?");
                stmt.setString(9, "");
                stmt.setInt(10, 0);
                LOG.debug("{}", (Object)stmt);
                int n = stmt.executeUpdate();
            }
        }
    }

    @Override
    protected int getCaseId(TaskCase kase) throws SQLException {
        PreparedStatement stmt;
        String sql;
        LOG.debug("Query for id of case {} ", (Object)kase.format());
        try (Connection conn = this.getConnection();){
            sql = "SELECT * FROM task_case WHERE SUITE_CLASS = ? AND CASE_CLASS = ? AND CASE_METHOD = ? AND CASE_DATA_INFO = ? AND CASE_DATA = ?";
            stmt = conn.prepareStatement("SELECT * FROM task_case WHERE SUITE_CLASS = ? AND CASE_CLASS = ? AND CASE_METHOD = ? AND CASE_DATA_INFO = ? AND CASE_DATA = ?");
            stmt.setString(1, kase.getSuiteClass());
            stmt.setString(2, kase.getCaseClass());
            stmt.setString(3, kase.getCaseMethod());
            stmt.setString(4, kase.getCaseDataInfo());
            stmt.setString(5, kase.getCaseData());
            stmt.setMaxRows(1);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt("TASK_CASE_ID");
                return n;
            }
        }
        conn = this.getConnection();
        var3_3 = null;
        try {
            sql = "INSERT INTO task_case (SUITE_CLASS, CASE_CLASS, CASE_METHOD, CASE_DATA_INFO, CASE_DATA) VALUES (?,?,?,?,?);";
            stmt = conn.prepareStatement("INSERT INTO task_case (SUITE_CLASS, CASE_CLASS, CASE_METHOD, CASE_DATA_INFO, CASE_DATA) VALUES (?,?,?,?,?);", 1);
            stmt.setString(1, kase.getSuiteClass());
            stmt.setString(2, kase.getCaseClass());
            stmt.setString(3, kase.getCaseMethod());
            stmt.setString(4, kase.getCaseDataInfo());
            stmt.setString(5, kase.getCaseData());
            int rs = stmt.executeUpdate();
        }
        catch (Throwable sql2) {
            var3_3 = sql2;
            throw sql2;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable sql2) {
                        var3_3.addSuppressed(sql2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = this.getConnection();
        var3_3 = null;
        try {
            sql = "SELECT * FROM task_case WHERE SUITE_CLASS = ? AND CASE_CLASS = ? AND CASE_METHOD = ? AND CASE_DATA_INFO = ? AND CASE_DATA = ? ORDER BY TASK_CASE_ID DESC;";
            stmt = conn.prepareStatement("SELECT * FROM task_case WHERE SUITE_CLASS = ? AND CASE_CLASS = ? AND CASE_METHOD = ? AND CASE_DATA_INFO = ? AND CASE_DATA = ? ORDER BY TASK_CASE_ID DESC;");
            stmt.setString(1, kase.getSuiteClass());
            stmt.setString(2, kase.getCaseClass());
            stmt.setString(3, kase.getCaseMethod());
            stmt.setString(4, kase.getCaseDataInfo());
            stmt.setString(5, kase.getCaseData());
            stmt.setMaxRows(1);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt("TASK_CASE_ID");
                return n;
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        throw new SQLException();
    }

    @Override
    protected Connection getConnection() throws SQLException {
        return this.connPool.getConnection();
    }

    @Override
    protected boolean acquireExecutionLock(Connection conn, String lock) throws SQLException {
        return true;
    }

    @Override
    protected boolean releaseExecutionLock(Connection conn, String lock) throws SQLException {
        return true;
    }

    private void initSchema() throws SQLException, IOException {
        try (Connection conn = this.getConnection();){
            ScriptRunner runner = new ScriptRunner(conn, true, true);
            try (InputStreamReader isr = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("db/report-h2.sql"));){
                runner.runScript(isr);
            }
        }
    }

    static {
        try {
            Class.forName(DB_DRIVER).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException("Cannot load database driver: org.h2.Driver", ex);
        }
    }
}

