/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.db;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import com.tascape.reactor.ExecutionResult;
import com.tascape.reactor.TaskSuite;
import com.tascape.reactor.Utils;
import com.tascape.reactor.db.DbHandler;
import com.tascape.reactor.db.SuiteResult;
import com.tascape.reactor.db.TaskCase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlHandler
extends DbHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MysqlHandler.class);
    private static final String DB_DRIVER = "com.mysql.jdbc.Driver";
    protected static final String DB_HOST = SYS_CONFIG.getDatabaseHost();
    protected static final String DB_SCHEMA = SYS_CONFIG.getDatabaseSchema();
    protected static final String DB_USER = SYS_CONFIG.getDatabaseUser();
    protected static final String DB_PASS = SYS_CONFIG.getDatabasePass();
    protected static final int DB_POOL_SIZE = SYS_CONFIG.getDatabasePoolSize();
    private static final String JDBC_URL = "jdbc:mysql://" + DB_HOST + "/" + DB_SCHEMA;
    protected BoneCP connPool;

    @Override
    protected void init() throws Exception {
        BoneCPConfig connPoolConfig = new BoneCPConfig();
        connPoolConfig.setJdbcUrl(JDBC_URL);
        connPoolConfig.setUsername(DB_USER);
        connPoolConfig.setPassword(DB_PASS);
        connPoolConfig.setMaxConnectionsPerPartition(DB_POOL_SIZE);
        connPoolConfig.setMaxConnectionAgeInSeconds(600L);
        connPoolConfig.setDefaultAutoCommit(true);
        connPoolConfig.setIdleConnectionTestPeriodInSeconds(30L);
        connPoolConfig.setConnectionTestStatement("SELECT 1");
        this.connPool = new BoneCP(connPoolConfig);
    }

    @Override
    protected Connection getConnection() throws SQLException {
        return this.connPool.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueSuiteExecution(TaskSuite suite, String execId) throws SQLException {
        LOG.debug("Queue suite for execution with execution id {}", (Object)execId);
        String lock = this.getDbLock(execId);
        try (Connection conn = this.getConnection();){
            try {
                if (!this.acquireExecutionLock(conn, lock)) {
                    throw new SQLException("Cannot acquire lock of name " + lock);
                }
                if (this.queueTaskSuite(suite, execId)) {
                    this.queueCaseResults(execId, suite.getCases());
                }
            }
            finally {
                this.releaseExecutionLock(conn, lock);
            }
        }
    }

    @Override
    public boolean queueTaskSuite(TaskSuite suite, String execId) throws SQLException {
        LOG.debug("Queueing suite result with execution id {} ", (Object)execId);
        String sql = "SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?";
        SuiteResult sr = new SuiteResult(suite, execId);
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM suite_result WHERE SUITE_RESULT_ID = ?", 1005, 1008);
            stmt.setMaxRows(1);
            stmt.setString(1, execId);
            ResultSet rs = stmt.executeQuery();
            if (rs.first()) {
                LOG.debug("Suite execution {} is already queued ", (Object)execId);
                boolean bl = false;
                return bl;
            }
            Long time = System.currentTimeMillis();
            LOG.debug("Queueing suite execution {}", (Object)execId);
            rs.moveToInsertRow();
            sr.update(rs);
            rs.insertRow();
            rs.last();
            rs.updateRow();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    protected int getCaseId(TaskCase kase) throws SQLException {
        LOG.debug("Query for id of case {} ", (Object)kase.format());
        String sql = "SELECT * FROM task_case WHERE SUITE_CLASS = ? AND CASE_CLASS = ? AND CASE_METHOD = ? AND CASE_DATA_INFO = ? AND CASE_DATA = ?";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM task_case WHERE SUITE_CLASS = ? AND CASE_CLASS = ? AND CASE_METHOD = ? AND CASE_DATA_INFO = ? AND CASE_DATA = ?", 1005, 1008);
            stmt.setString(1, kase.getSuiteClass());
            stmt.setString(2, kase.getCaseClass());
            stmt.setString(3, kase.getCaseMethod());
            stmt.setString(4, kase.getCaseDataInfo());
            stmt.setString(5, kase.getCaseData());
            stmt.setMaxRows(1);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                rs.moveToInsertRow();
                rs.updateString("SUITE_CLASS", kase.getSuiteClass());
                rs.updateString("CASE_CLASS", kase.getCaseClass());
                rs.updateString("CASE_METHOD", kase.getCaseMethod());
                rs.updateString("CASE_DATA_INFO", kase.getCaseDataInfo());
                rs.updateString("CASE_DATA", kase.getCaseData());
                rs.insertRow();
                rs.last();
                rs.updateRow();
            }
            int n = rs.getInt("TASK_CASE_ID");
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queueCaseResults(String execId, List<TaskCase> cases) throws SQLException {
        LOG.debug("Queue {} case result(s) with execution id {} ", (Object)cases.size(), (Object)execId);
        String sql = "SELECT * FROM case_result WHERE SUITE_RESULT = ?";
        Map<String, Integer> idMap = this.getCaseIds(cases);
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM case_result WHERE SUITE_RESULT = ?", 1005, 1008);
            stmt.setMaxRows(1);
            stmt.setString(1, execId);
            ResultSet rs = stmt.executeQuery();
            boolean autoCommit = conn.getAutoCommit();
            try {
                conn.setAutoCommit(false);
                int index = 0;
                for (TaskCase kase : cases) {
                    ++index;
                    rs.moveToInsertRow();
                    Integer tcid = idMap.get(kase.format());
                    if (tcid == null) {
                        tcid = this.getCaseId(kase);
                    }
                    rs.updateString("CASE_RESULT_ID", Utils.getUniqueId());
                    rs.updateString("SUITE_RESULT", execId);
                    rs.updateInt("TASK_CASE_ID", (int)tcid);
                    rs.updateString("EXECUTION_RESULT", ExecutionResult.QUEUED.getName());
                    rs.updateLong("START_TIME", System.currentTimeMillis());
                    rs.updateLong("STOP_TIME", System.currentTimeMillis());
                    rs.updateString("CASE_STATION", ".");
                    rs.updateString("CASE_ENV", ".");
                    rs.updateString("LOG_DIR", ".");
                    rs.updateInt("RETRY", SYS_CONFIG.getCaseRetry());
                    rs.insertRow();
                    rs.last();
                    rs.updateRow();
                    if (index % 100 != 0) continue;
                    conn.commit();
                }
                conn.commit();
            }
            finally {
                conn.setAutoCommit(autoCommit);
            }
        }
    }

    @Override
    protected boolean acquireExecutionLock(Connection conn, String lock) throws SQLException {
        String sqlLock = String.format("SELECT GET_LOCK('%s', 1200);", lock);
        LOG.debug("Acquire lock {}", (Object)lock);
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sqlLock);){
            if (rs.next() && "1".equals(rs.getString(1))) {
                LOG.trace("{} is locked", (Object)lock);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean releaseExecutionLock(Connection conn, String lock) throws SQLException {
        String sqlRelease = String.format("SELECT RELEASE_LOCK('%s');", lock);
        LOG.debug("Release lock {}", (Object)lock);
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sqlRelease);){
            if (rs.next() && "1".equals(rs.getString(1))) {
                LOG.trace("{} is released", (Object)lock);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            conn.close();
        }
        return false;
    }

    public static void main(String[] args) throws SQLException {
        MysqlHandler db = new MysqlHandler();
        TaskCase tc = new TaskCase();
        tc.setSuiteClass("a");
        LOG.debug("case id = {}", (Object)db.getCaseId(tc));
    }

    static {
        try {
            Class.forName(DB_DRIVER).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException("Cannot load database driver: com.mysql.jdbc.Driver", ex);
        }
    }
}

