/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.db;

import com.tascape.reactor.db.MysqlHandler;
import com.tascape.reactor.db.TaskCase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlHandler
extends MysqlHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresqlHandler.class);
    private static final String DB_DRIVER = "org.postgresql.Driver";
    private static final String JDBC_URL = "jdbc:postgresql://" + DB_HOST + "/" + DB_SCHEMA;

    @Override
    protected boolean acquireExecutionLock(Connection conn, String lock) throws SQLException {
        String sqlLock = String.format("SELECT pg_advisory_lock(%d);", this.hash(lock));
        LOG.debug("Acquire lock {}", (Object)lock);
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sqlLock);){
            if (rs.next() && "1".equals(rs.getString(1))) {
                LOG.trace("{} is locked", (Object)lock);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean releaseExecutionLock(Connection conn, String lock) throws SQLException {
        String sqlRelease = String.format("SELECT pg_advisory_unlock(%d);", this.hash(lock));
        LOG.debug("Release lock {}", (Object)lock);
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sqlRelease);){
            if (rs.next() && "1".equals(rs.getString(1))) {
                LOG.trace("{} is released", (Object)lock);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            conn.close();
        }
        return false;
    }

    public static void main(String[] args) throws SQLException {
        PostgresqlHandler db = new PostgresqlHandler();
        TaskCase tc = new TaskCase();
        tc.setSuiteClass("a");
        LOG.debug("case id = {}", (Object)db.getCaseId(tc));
    }

    static {
        try {
            Class.forName(DB_DRIVER).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException("Cannot load database driver: org.postgresql.Driver", ex);
        }
    }
}

