/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.db;

import com.tascape.reactor.TaskSuite;
import com.tascape.reactor.db.CaseResult;
import com.tascape.reactor.db.DbHandler;
import com.tascape.reactor.db.SuiteProperty;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@MappedSuperclass
@Table(name="suite_result")
@XmlRootElement
public class SuiteResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TABLE_NAME = "suite_result";
    public static final String SUITE_RESULT_ID = "SUITE_RESULT_ID";
    public static final String SUITE_NAME = "SUITE_NAME";
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String JOB_NAME = "JOB_NAME";
    public static final String JOB_BUILD_NUMBER = "JOB_BUILD_NUMBER";
    public static final String JOB_BUILD_URL = "JOB_BUILD_URL";
    public static final String EXECUTION_RESULT = "EXECUTION_RESULT";
    public static final String START_TIME = "START_TIME";
    public static final String STOP_TIME = "STOP_TIME";
    public static final String NUMBER_OF_CASES = "NUMBER_OF_CASES";
    public static final String NUMBER_OF_FAILURE = "NUMBER_OF_FAILURE";
    public static final String INVISIBLE_ENTRY = "INVISIBLE_ENTRY";
    public static final String PRODUCT_UNDER_TASK = "PRODUCT_UNDER_TASK";
    @Id
    @Basic(optional=false)
    @Column(name="SUITE_RESULT_ID")
    private String suiteResultId;
    @Column(name="SUITE_NAME")
    private String suiteName;
    @Column(name="PROJECT_NAME")
    private String projectName;
    @Column(name="JOB_NAME")
    private String jobName;
    @Column(name="JOB_BUILD_NUMBER")
    private Integer jobBuildNumber;
    @Column(name="JOB_BUILD_URL")
    private String jobBuildUrl;
    @Column(name="EXECUTION_RESULT")
    private String executionResult;
    @Column(name="START_TIME")
    private Long startTime;
    @Column(name="STOP_TIME")
    private Long stopTime;
    @Column(name="NUMBER_OF_CASES")
    private Integer numberOfCases;
    @Column(name="NUMBER_OF_FAILURE")
    private Integer numberOfFailure;
    @Column(name="INVISIBLE_ENTRY")
    private Boolean invisibleEntry;
    @Column(name="PRODUCT_UNDER_TASK")
    private String productUnderTask;
    @OneToMany(mappedBy="suiteResult")
    private List<CaseResult> caseResultList;
    @OneToMany(mappedBy="suiteResult")
    private List<SuiteProperty> suitePropertyList;

    public SuiteResult() {
    }

    public SuiteResult(TaskSuite taskSuite, String execId) {
        Long time = System.currentTimeMillis();
        this.suiteResultId = execId;
        this.suiteName = taskSuite.getName();
        this.projectName = taskSuite.getProjectName();
        this.jobName = DbHandler.SYS_CONFIG.getJobName();
        this.jobBuildNumber = DbHandler.SYS_CONFIG.getJobBuildNumber();
        this.jobBuildUrl = DbHandler.SYS_CONFIG.getJobBuildUrl();
        this.executionResult = "";
        this.startTime = time;
        this.stopTime = time + 1L;
        this.numberOfCases = taskSuite.getCases().size();
        this.numberOfFailure = taskSuite.getCases().size();
        this.invisibleEntry = false;
        this.productUnderTask = DbHandler.SYS_CONFIG.getProdUnderTask();
        this.invisibleEntry = !DbHandler.SYS_CONFIG.getResultVisibility();
    }

    public SuiteResult(ResultSet rs) throws SQLException {
        this.suiteResultId = rs.getString(SUITE_RESULT_ID);
        this.suiteName = rs.getString(SUITE_NAME);
        this.projectName = rs.getNString(PROJECT_NAME);
        this.jobName = rs.getString(JOB_NAME);
        this.jobBuildNumber = rs.getInt(JOB_BUILD_NUMBER);
        this.jobBuildUrl = rs.getString(JOB_BUILD_URL);
        this.executionResult = rs.getString(EXECUTION_RESULT);
        this.startTime = rs.getLong(START_TIME);
        this.stopTime = rs.getLong(STOP_TIME);
        this.numberOfCases = rs.getInt(NUMBER_OF_CASES);
        this.numberOfFailure = rs.getInt(NUMBER_OF_FAILURE);
        this.invisibleEntry = rs.getBoolean(INVISIBLE_ENTRY);
        this.productUnderTask = rs.getString(PRODUCT_UNDER_TASK);
    }

    public void update(ResultSet rs) throws SQLException {
        rs.updateString(SUITE_RESULT_ID, this.getSuiteResultId());
        rs.updateString(SUITE_NAME, this.getSuiteName());
        rs.updateString(PROJECT_NAME, this.getProjectName());
        rs.updateString(JOB_NAME, this.getJobName());
        rs.updateInt(JOB_BUILD_NUMBER, (int)this.getJobBuildNumber());
        rs.updateString(JOB_BUILD_URL, this.getJobBuildUrl());
        rs.updateLong(START_TIME, (long)this.getStartTime());
        rs.updateLong(STOP_TIME, (long)this.getStartTime());
        rs.updateString(EXECUTION_RESULT, this.getExecutionResult());
        rs.updateInt(NUMBER_OF_CASES, (int)this.getNumberOfCases());
        rs.updateInt(NUMBER_OF_FAILURE, (int)this.getNumberOfFailure());
        rs.updateBoolean(INVISIBLE_ENTRY, (boolean)this.getInvisibleEntry());
        rs.updateString(PRODUCT_UNDER_TASK, this.getProductUnderTask());
    }

    public SuiteResult(String suiteResultId) {
        this.suiteResultId = suiteResultId;
    }

    public String getSuiteResultId() {
        return this.suiteResultId;
    }

    public void setSuiteResultId(String suiteResultId) {
        this.suiteResultId = suiteResultId;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public Integer getJobBuildNumber() {
        return this.jobBuildNumber;
    }

    public void setJobBuildNumber(Integer jobBuildNumber) {
        this.jobBuildNumber = jobBuildNumber;
    }

    public String getJobBuildUrl() {
        return this.jobBuildUrl;
    }

    public void setJobBuildUrl(String jobBuildUrl) {
        this.jobBuildUrl = jobBuildUrl;
    }

    public String getExecutionResult() {
        return this.executionResult;
    }

    public void setExecutionResult(String executionResult) {
        this.executionResult = executionResult;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(Long stopTime) {
        this.stopTime = stopTime;
    }

    public Integer getNumberOfCases() {
        return this.numberOfCases;
    }

    public void setNumberOfCases(Integer numberOfCases) {
        this.numberOfCases = numberOfCases;
    }

    public Integer getNumberOfFailure() {
        return this.numberOfFailure;
    }

    public void setNumberOfFailure(Integer numberOfFailure) {
        this.numberOfFailure = numberOfFailure;
    }

    public Boolean getInvisibleEntry() {
        return this.invisibleEntry;
    }

    public void setInvisibleEntry(Boolean invisibleEntry) {
        this.invisibleEntry = invisibleEntry;
    }

    public String getProductUnderTask() {
        return this.productUnderTask;
    }

    public void setProductUnderTask(String productUnderTask) {
        this.productUnderTask = productUnderTask;
    }

    @XmlTransient
    public List<CaseResult> getCaseResultList() {
        return this.caseResultList;
    }

    public void setCaseResultList(List<CaseResult> caseResultList) {
        this.caseResultList = caseResultList;
    }

    public List<SuiteProperty> getSuitePropertyList() {
        return this.suitePropertyList;
    }

    public void setSuitePropertyList(List<SuiteProperty> suitePropertyList) {
        this.suitePropertyList = suitePropertyList;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.suiteResultId != null ? this.suiteResultId.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SuiteResult)) {
            return false;
        }
        SuiteResult other = (SuiteResult)object;
        return !(this.suiteResultId == null && other.suiteResultId != null || this.suiteResultId != null && !this.suiteResultId.equals(other.suiteResultId));
    }

    public String toString() {
        return this.getClass().getName() + "[ suiteResultId=" + this.suiteResultId + " ]";
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
}

