/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.db;

import com.tascape.reactor.db.CaseResult;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCase {
    private static final Logger LOG = LoggerFactory.getLogger(TaskCase.class);
    public static final String TABLE_NAME = "task_case";
    public static final String TASK_CASE_ID = "TASK_CASE_ID";
    public static final String SUITE_CLASS = "SUITE_CLASS";
    public static final String CASE_CLASS = "CASE_CLASS";
    public static final String CASE_METHOD = "CASE_METHOD";
    public static final String CASE_DATA_INFO = "CASE_DATA_INFO";
    public static final String CASE_DATA = "CASE_DATA";
    public static final String CASE_ISSUES = "CASE_ISSUES";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="TASK_CASE_ID")
    private Integer taskCaseId;
    @Basic(optional=false)
    @Column(name="SUITE_CLASS")
    private String suiteClass;
    @Basic(optional=false)
    @Column(name="CASE_CLASS")
    private String caseClass;
    @Basic(optional=false)
    @Column(name="CASE_METHOD")
    private String caseMethod;
    @Column(name="CASE_DATA_INFO")
    private String caseDataInfo = "";
    @Column(name="CASE_DATA")
    private String caseData = "";
    @Column(name="CASE_ISSUES")
    private String caseIssues = "";
    @OneToMany(mappedBy="taskCaseId")
    private List<CaseResult> caseResultList;
    private int priority = 3;

    public TaskCase(TaskCase tc) {
        this.suiteClass = tc.getSuiteClass() + "";
        this.caseClass = tc.getCaseClass() + "";
        this.caseMethod = tc.getCaseMethod() + "";
        this.caseDataInfo = tc.getCaseDataInfo() + "";
        this.caseData = tc.getCaseData() + "";
        this.caseIssues = tc.getCaseIssues() + "";
        this.priority = tc.getPriority();
    }

    public TaskCase(Map<String, Object> row) {
        this.taskCaseId = (int)((Integer)row.get(TASK_CASE_ID));
        this.suiteClass = row.get(SUITE_CLASS) + "";
        this.caseClass = row.get(CASE_CLASS) + "";
        this.caseMethod = row.get(CASE_METHOD) + "";
        this.caseDataInfo = row.get(CASE_DATA_INFO) + "";
        this.caseData = row.get(CASE_DATA) + "";
    }

    public TaskCase() {
    }

    public Integer getTaskCaseId() {
        return this.taskCaseId;
    }

    public void setTaskCaseId(Integer taskCaseId) {
        this.taskCaseId = taskCaseId;
    }

    public String getSuiteClass() {
        return this.suiteClass;
    }

    public void setSuiteClass(String suiteClass) {
        this.suiteClass = suiteClass;
    }

    public String getCaseClass() {
        return this.caseClass;
    }

    public void setCaseClass(String caseClass) {
        this.caseClass = caseClass;
    }

    public String getCaseMethod() {
        return this.caseMethod;
    }

    public void setCaseMethod(String caseMethod) {
        this.caseMethod = caseMethod;
    }

    public String getCaseDataInfo() {
        return this.caseDataInfo;
    }

    public void setCaseDataInfo(String caseDataInfo) {
        this.caseDataInfo = caseDataInfo;
    }

    public String getCaseData() {
        return this.caseData;
    }

    public void setCaseData(String caseData) {
        this.caseData = caseData;
    }

    public String getCaseIssues() {
        return this.caseIssues;
    }

    public void setCaseIssues(String caseIssues) {
        this.caseIssues = caseIssues;
    }

    @XmlTransient
    public List<CaseResult> getCaseResultList() {
        return this.caseResultList;
    }

    public void setCaseResultList(List<CaseResult> caseResultList) {
        this.caseResultList = caseResultList;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.taskCaseId != null ? this.taskCaseId.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TaskCase)) {
            return false;
        }
        TaskCase other = (TaskCase)object;
        return !(this.taskCaseId == null && other.taskCaseId != null || this.taskCaseId != null && !this.taskCaseId.equals(other.taskCaseId));
    }

    public String toString() {
        return this.taskCaseId + " " + this.format();
    }

    public String format() {
        return String.format("%s.%s.%s.%s.%s", this.suiteClass, this.caseClass, this.caseMethod, this.caseDataInfo, this.caseData);
    }

    public String formatForLogPath() {
        return String.format("%s.%s.%s.%s", StringUtils.substringAfterLast((String)this.suiteClass, (String)"."), StringUtils.substringAfterLast((String)this.caseClass, (String)"."), this.caseMethod, this.caseDataInfo.isEmpty() ? "" : StringUtils.substringAfterLast((String)this.caseDataInfo, (String)"#"));
    }
}

