/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.driver;

import com.google.common.collect.Lists;
import com.tascape.reactor.SystemConfiguration;
import com.tascape.reactor.driver.EntityDriver;
import com.tascape.reactor.libx.DefaultExecutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerClient
extends EntityDriver {
    private static final Logger LOG = LoggerFactory.getLogger(DockerClient.class);
    public static final String SYSPROP_DOCKER_EXECUTABLE = "reactor.comm.DOCKER_EXECUTABLE";
    private static final String DOCKER = DockerClient.locateDocker();

    private static String locateDocker() {
        String sysDocker = SystemConfiguration.getInstance().getProperty(SYSPROP_DOCKER_EXECUTABLE);
        if (sysDocker != null) {
            return sysDocker;
        }
        String paths = System.getenv().get("PATH");
        if (StringUtils.isBlank((CharSequence)paths)) {
            paths = System.getenv().get("Path");
        }
        if (StringUtils.isBlank((CharSequence)paths)) {
            paths = System.getenv().get("path");
        }
        if (StringUtils.isNotBlank((CharSequence)paths)) {
            String[] path;
            paths = paths + System.getProperty("path.separator") + "/usr/local/bin";
            for (String p : path = paths.split(System.getProperty("path.separator"))) {
                LOG.debug("path {}", (Object)p);
                File f = Paths.get(p, "docker").toFile();
                if (f.exists()) {
                    return f.getAbsolutePath();
                }
                f = Paths.get(p, "docker.bat").toFile();
                if (f.exists()) {
                    return f.getAbsolutePath();
                }
                f = Paths.get(p, "docker.exe").toFile();
                if (!f.exists()) continue;
                return f.getAbsolutePath();
            }
        }
        throw new RuntimeException("Cannot find docker based on system PATH. You can specify system property reactor.comm.DOCKER_EXECUTABLE=/full/path/to/docker");
    }

    public List<String> docker(List<Object> arguments) throws IOException {
        CommandLine cmdLine = new CommandLine(DOCKER);
        arguments.forEach(arg -> cmdLine.addArgument(arg + ""));
        LOG.debug("[{} {}]", (Object)cmdLine.getExecutable(), (Object)StringUtils.join((Object[])cmdLine.getArguments(), (String)" "));
        ArrayList<String> output = new ArrayList<String>();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler(new ESH(output));
        if (executor.execute(cmdLine) != 0) {
            throw new IOException(cmdLine + " failed");
        }
        return output;
    }

    public ExecuteWatchdog dockerAsync(List<Object> arguments, OutputStream out) throws IOException {
        CommandLine cmdLine = new CommandLine(DOCKER);
        arguments.forEach(arg -> cmdLine.addArgument(arg + ""));
        LOG.debug("[{} {}]", (Object)cmdLine.getExecutable(), (Object)StringUtils.join((Object[])cmdLine.getArguments(), (String)" "));
        ArrayList output = new ArrayList();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(-1L);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWatchdog(watchdog);
        PrintWriter writer = new PrintWriter(out);
        ESH esh = new ESH(writer);
        executor.setStreamHandler(esh);
        executor.execute(cmdLine, (ExecuteResultHandler)new DefaultExecuteResultHandler());
        return watchdog;
    }

    public ExecuteWatchdog tailServiceLogs(String serviceName) throws IOException {
        ArrayList cmd = Lists.newArrayList((Object[])new Object[]{"service", "logs", "--tail", "1", "-f", serviceName});
        File log = super.saveAsTextFile(serviceName, "");
        FileOutputStream out = FileUtils.openOutputStream((File)log);
        return this.dockerAsync(cmd, out);
    }

    @Override
    public String getName() {
        return DockerClient.class.getSimpleName();
    }

    @Override
    public String getVersion() {
        try {
            return this.docker(Lists.newArrayList((Object[])new Object[]{"-v"})).get(0);
        }
        catch (IOException ex) {
            LOG.warn(ex.getMessage());
            return "NA";
        }
    }

    @Override
    public void reset() throws Exception {
        LOG.debug("na");
    }

    public static void main(String[] args) throws Exception {
        DockerClient dc = new DockerClient();
        String v = dc.getVersion();
        LOG.info(v);
        ExecuteWatchdog dog = dc.tailServiceLogs("msc_siteservice");
        dc.delay(3000L);
        dog.killedProcess();
        System.exit(0);
    }

    private class ESH
    implements ExecuteStreamHandler {
        private BufferedReader bis;
        private final List<String> list;
        private final PrintWriter writer;

        ESH() {
            this.list = null;
            this.writer = null;
        }

        ESH(List<String> list) {
            this.list = list;
            this.writer = null;
        }

        ESH(PrintWriter writer) {
            this.list = null;
            this.writer = writer;
        }

        public void setProcessInputStream(OutputStream out) throws IOException {
        }

        public void setProcessErrorStream(InputStream in) throws IOException {
        }

        public void setProcessOutputStream(InputStream in) throws IOException {
            this.bis = new BufferedReader(new InputStreamReader(in));
        }

        public void start() throws IOException {
            String line;
            while ((line = this.bis.readLine()) != null) {
                LOG.trace(line);
                if (this.list != null) {
                    this.list.add(line);
                }
                if (this.writer == null) continue;
                this.writer.println(line);
                this.writer.flush();
            }
        }

        public void stop() throws IOException {
        }
    }
}

