/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.driver;

import com.tascape.reactor.AbstractCaseResource;
import com.tascape.reactor.comm.EntityCommunication;
import com.tascape.reactor.task.AbstractCase;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityDriver
extends AbstractCaseResource {
    private static final Logger LOG = LoggerFactory.getLogger(EntityDriver.class);
    private AbstractCase kase;

    @Override
    public Path getLogPath() {
        if (this.kase == null) {
            return super.getLogPath();
        }
        return this.kase.getLogPath();
    }

    public void setCase(AbstractCase kase) {
        this.kase = kase;
        Class<?> c = this.getClass();
        while (!c.equals(EntityDriver.class)) {
            LOG.trace("{} {}", (Object)this, c);
            Stream.of(c.getDeclaredFields()).filter(f -> EntityCommunication.class.isAssignableFrom(f.getType())).forEach(f -> {
                f.setAccessible(true);
                try {
                    EntityCommunication ec = (EntityCommunication)f.get(this);
                    if (ec != null) {
                        ec.setDriver(this);
                        ec.setCase(kase);
                    } else {
                        LOG.trace("null for {}", f);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    LOG.warn("", (Throwable)ex);
                }
            });
            c = c.getSuperclass();
        }
    }

    protected AbstractCase getCase() {
        return this.kase;
    }

    public abstract String getName();

    public abstract String getVersion();

    public abstract void reset() throws Exception;
}

