/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.suite;

import com.tascape.reactor.ExecutionResult;
import com.tascape.reactor.Reactor;
import com.tascape.reactor.SystemConfiguration;
import com.tascape.reactor.driver.CaseDriver;
import com.tascape.reactor.driver.EntityDriver;
import com.tascape.reactor.driver.PoolableEntityDriver;
import com.tascape.reactor.suite.Environment;
import com.tascape.reactor.task.AbstractCase;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSuite {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSuite.class);
    private static final ThreadLocal<Map<String, Environment>> ENVIRONMENTS = new ThreadLocal<Map<String, Environment>>(){

        @Override
        protected Map<String, Environment> initialValue() {
            return new HashMap<String, Environment>();
        }
    };
    private static final List<AbstractSuite> SUITES = new ArrayList<AbstractSuite>();
    private final List<Class<? extends AbstractCase>> caseClasses = new ArrayList<Class<? extends AbstractCase>>();
    private final Environment suiteEnvironment = new Environment();
    protected final SystemConfiguration SYSCONFIG = SystemConfiguration.getInstance();
    protected ExecutionResult executionResult;

    public static void putEnvionment(String suiteClass, Environment env) {
        ENVIRONMENTS.get().put(suiteClass, env);
    }

    public static Environment getEnvionment(String suiteClass) {
        Environment env = ENVIRONMENTS.get().get(suiteClass);
        return env;
    }

    public static void addSuite(AbstractSuite suite) {
        SUITES.add(suite);
    }

    public static List<AbstractSuite> getSuites() {
        return SUITES;
    }

    public int getNumberOfEnvs() {
        return 0;
    }

    public int getPriority() {
        LOG.warn("Please override to return the minimal priority, of which you would like to run cases in this suite. The default is Priority.P3");
        return 3;
    }

    public void runFailFast(Throwable t) throws Exception {
        LOG.warn("there is no fail fast operations in suite, please override, and return true, if you want");
    }

    public void setUp() throws Exception {
        Environment env = AbstractSuite.getEnvionment(this.getClass().getName());
        if (env == null || env.isEmpty()) {
            try {
                this.setUpEnvironment();
            }
            catch (Throwable t) {
                this.runFailFast(t);
            }
            AbstractSuite.putEnvionment(this.getClass().getName(), this.suiteEnvironment);
            this.suiteEnvironment.setName(Thread.currentThread().getName() + " " + this.getEnvironmentName());
        }
    }

    public void runByClass() throws Exception {
        this.caseClasses.forEach(clazz -> {
            JUnitCore core = new JUnitCore();
            core.run(Request.classWithoutSuiteMethod((Class)clazz));
        });
    }

    public void tearDown() {
        try {
            this.tearDownEnvironment();
        }
        catch (Throwable t) {
            LOG.warn("Cannot tearing down properly", t);
        }
    }

    public List<Class<? extends AbstractCase>> getCaseClasses() {
        return this.caseClasses;
    }

    protected void putCaseDirver(CaseDriver caseDriver, EntityDriver driver) {
        String key = caseDriver.toString();
        LOG.debug("Putting runtime driver {}={} into suite environment", (Object)key, (Object)driver);
        Class<? extends EntityDriver> clazz = caseDriver.getDriverClass();
        if (clazz != null && !clazz.isInstance(driver)) {
            throw new RuntimeException("wrong driver type, " + key + " vs " + driver);
        }
        EntityDriver d = (EntityDriver)this.suiteEnvironment.get(key);
        if (d == null) {
            this.suiteEnvironment.put(key, driver);
            return;
        }
        if (driver.equals(d)) {
            LOG.warn("Tried to add the same driver again: {}={}", (Object)key, (Object)driver);
            return;
        }
        if (d instanceof PoolableEntityDriver && driver instanceof PoolableEntityDriver) {
            ((PoolableEntityDriver)PoolableEntityDriver.class.cast(d)).next((PoolableEntityDriver)PoolableEntityDriver.class.cast(driver));
            return;
        }
        throw new UnsupportedOperationException("Cannot add non-poolable driver with the same key " + key);
    }

    protected <T extends AbstractCase> void addCaseClass(Class<T> clazz) {
        if (this.caseClasses.contains(clazz)) {
            throw new UnsupportedOperationException("Adding same case class multiple times is not supported yet.");
        }
        this.caseClasses.add(clazz);
    }

    protected String getSuiteProperty(String name, String defValue) {
        String value = this.SYSCONFIG.getProperty(name);
        if (value == null) {
            value = defValue;
        }
        return value;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public abstract String getProjectName();

    public abstract void setUpCaseClasses();

    protected abstract void setUpEnvironment() throws Exception;

    protected String getEnvironmentName() {
        return "";
    }

    public abstract String getProductUnderTask();

    protected abstract void tearDownEnvironment();

    public void setExecutionResult(ExecutionResult executionResult) {
        this.executionResult = executionResult;
    }

    public ExecutionResult getExecutionResult() {
        return ExecutionResult.NA;
    }

    public static void main(String[] args) throws Exception {
        Class c;
        String className;
        SystemConfiguration sysConfig = SystemConfiguration.getInstance();
        Field fClasses = ClassLoader.class.getDeclaredField("classes");
        ClassLoader cl = AbstractSuite.class.getClassLoader();
        fClasses.setAccessible(true);
        List classes = (List)fClasses.get(cl);
        String suiteClassName = "";
        String stop = AbstractSuite.class.getName() + "$1";
        Iterator iterator = classes.iterator();
        while (iterator.hasNext() && !(className = (c = (Class)iterator.next()).getName()).equals(stop)) {
            suiteClassName = className;
        }
        sysConfig.setSuite(suiteClassName);
        Reactor.main(args);
    }
}

