/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.suite;

import com.tascape.reactor.Utils;
import com.tascape.reactor.suite.AbstractSuite;
import com.tascape.reactor.task.JUnit4Case;
import com.tascape.reactor.task.JUnit4CleanupCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnit4Suite
extends AbstractSuite {
    private static final Logger LOG = LoggerFactory.getLogger(JUnit4Suite.class);

    @Override
    public void setUpCaseClasses() {
        super.addCaseClass(JUnit4Case.class);
        super.addCaseClass(JUnit4CleanupCase.class);
    }

    @Override
    protected void setUpEnvironment() throws Exception {
        LOG.info("some suite setup here");
    }

    @Override
    protected String getEnvironmentName() {
        return "junit4";
    }

    @Override
    protected void tearDownEnvironment() {
        try {
            Utils.sleep(20000L, "waiting for teardown");
        }
        catch (InterruptedException ex) {
            LOG.warn(ex.getMessage());
        }
    }

    @Override
    public String getProjectName() {
        return "JUnit4";
    }

    @Override
    public String getProductUnderTask() {
        return "JUnit4 Sample 1.1";
    }
}

