/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.task;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tascape.reactor.AbstractCaseResource;
import com.tascape.reactor.AbstractCaseRunner;
import com.tascape.reactor.ExecutionResult;
import com.tascape.reactor.data.AbstractCaseData;
import com.tascape.reactor.data.CaseData;
import com.tascape.reactor.db.CaseResult;
import com.tascape.reactor.db.CaseResultMetric;
import com.tascape.reactor.driver.CaseDriver;
import com.tascape.reactor.driver.EntityDriver;
import com.tascape.reactor.suite.AbstractSuite;
import com.tascape.reactor.suite.Environment;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.ToBeImplementedException;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCase
extends AbstractCaseResource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCase.class);
    private static final ThreadLocal<AbstractCase> ABSTRACT_CASE = new ThreadLocal();
    @Rule
    public TestName testName = new TestName();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public Timeout globalTimeout = new Timeout(15L, TimeUnit.MINUTES);
    protected String execId = this.sysConfig.getExecId();
    private final Path caseLogPath = AbstractCaseResource.getCaseLogPath();
    protected CaseData caseData = AbstractCaseData.getCaseData();
    private final CaseResult tcr = AbstractCaseRunner.getCaseResult();
    private ExecutionResult result = ExecutionResult.NA;
    private final ExecutorService backgroundExecutorService;
    private final List<CaseResultMetric> resultMetrics = new LinkedList<CaseResultMetric>();
    private final Environment env;
    private final String suiteClass;
    private String externalId = "";

    public static void setCase(AbstractCase kase) {
        ABSTRACT_CASE.set(kase);
    }

    public static AbstractCase getCase() {
        return ABSTRACT_CASE.get();
    }

    public abstract String getApplicationUnderTask();

    public AbstractCase() {
        this.result.setPass(0);
        this.result.setFail(0);
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        builder.setDaemon(true);
        builder.setNameFormat(Thread.currentThread().getName() + "-%d");
        this.backgroundExecutorService = Executors.newCachedThreadPool(builder.build());
        this.suiteClass = this.tcr.getTaskCase().getSuiteClass();
        this.env = AbstractSuite.getEnvionment(this.suiteClass);
        AbstractCase.setCase(this);
    }

    @Override
    public Path getLogPath() {
        return this.caseLogPath;
    }

    protected <D extends EntityDriver> D getEntityDriver(CaseDriver caseDriver) {
        String key = caseDriver.toString();
        Class<? extends EntityDriver> clazz = caseDriver.getDriverClass();
        if (clazz == null) {
            throw new RuntimeException("EntityDriver type was not specified in CaseDriver instance.");
        }
        LOG.debug("Getting runtime driver (name={}, type={}) from suite environment", (Object)key, (Object)clazz.getName());
        if (this.suiteClass.isEmpty()) {
            return null;
        }
        EntityDriver driver = (EntityDriver)this.env.get(key);
        if (driver == null) {
            LOG.error("Cannot find driver of name={} and type={}, please check suite environemnt", (Object)key, (Object)clazz.getName());
            return null;
        }
        driver.setCase(this);
        return (D)driver;
    }

    protected CaseData getCaseData() {
        if (this.caseData != null) {
            LOG.debug("Getting injected case data {}={}", (Object)this.caseData.getClass().getName(), (Object)this.caseData.getValue());
        }
        return this.caseData;
    }

    protected <T extends CaseData> T getCaseData(Class<T> clazz) throws Exception {
        CaseData td = this.getCaseData();
        if (td == null) {
            LOG.debug("There is no injected case data, create a new instance of ", clazz);
            td = (CaseData)clazz.newInstance();
        }
        LOG.info("Case data {}: {}", (Object)td.getValue(), (Object)td.getDescription());
        this.setExternalId(td.getExternalId());
        if (td.isToBeImplemented()) {
            this.markAsToBeImplemented();
        }
        td.setAbstractCase(this);
        return (T)((CaseData)clazz.cast(td));
    }

    public String getExternalId() {
        return this.externalId;
    }

    protected void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public ExecutionResult getExecutionResult() {
        return this.result;
    }

    public void submitBackgroundTask(Runnable runnable) {
        this.backgroundExecutorService.submit(runnable);
    }

    public void cleanBackgoundTasks() {
        this.backgroundExecutorService.shutdownNow();
    }

    protected void updateCaseDataFormat(String value) {
        this.caseData.setValue(value);
        this.tcr.getTaskCase().setCaseData(value);
    }

    protected void setExecutionResult(ExecutionResult executionResult) {
        this.result = executionResult;
        if (executionResult.isFailure()) {
            throw new AssertionError((Object)("execution result: " + executionResult.result()));
        }
    }

    protected void requeue() {
        this.result = ExecutionResult.QUEUED;
        this.tcr.setCaseStation("");
    }

    protected void markAsToBeImplemented() {
        this.setExecutionResult(ExecutionResult.TBI);
        throw new ToBeImplementedException("this is a to-be-implemented case");
    }

    public List<CaseResultMetric> getResultMetrics() {
        return this.resultMetrics;
    }

    protected void putResultMetric(String group, String name, double value) {
        CaseResultMetric metric = new CaseResultMetric();
        metric.setMetricGroup(group);
        metric.setMetricName(name);
        metric.setMetricValue(value);
        LOG.info("Case result metric '{}' - '{}' - {}", new Object[]{group, name, value});
        this.resultMetrics.add(metric);
    }

    protected void captureScreens(long intervalMillis) {
        this.submitBackgroundTask(() -> {
            while (true) {
                try {
                    TimeUnit.MILLISECONDS.sleep(intervalMillis);
                }
                catch (InterruptedException ex) {
                    LOG.trace(ex.getMessage());
                    return;
                }
                this.captureScreen();
            }
        });
    }
}

