/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor.task;

import com.tascape.reactor.ExecutionResult;
import com.tascape.reactor.Reactor;
import com.tascape.reactor.data.CaseDataProvider;
import com.tascape.reactor.data.CaseIterationData;
import com.tascape.reactor.task.AbstractCase;
import com.tascape.reactor.task.Priority;
import com.tascape.reactor.task.SampleData;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.text.RandomStringGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(level=2)
public class JUnit4Case
extends AbstractCase {
    private static final Logger LOG = LoggerFactory.getLogger(JUnit4Case.class);

    @Before
    public void setUp() throws Exception {
        LOG.debug("Run something before case");
        LOG.debug("Please override");
    }

    @After
    public void tearDown() throws Exception {
        LOG.debug("Run something after case");
        LOG.debug("Please override");
    }

    @Override
    public String getApplicationUnderTask() {
        LOG.debug("Please override");
        return Reactor.class.getName();
    }

    @Test
    @Priority(level=0)
    public void runPositive() throws Exception {
        LOG.info("Sample positive case");
        LOG.debug("Sample positive case");
        LOG.trace("Sample positive case");
        Random r = new Random();
        this.putResultMetric("JUnit4", "positive-1", r.nextInt(100));
        this.putResultMetric("JUnit4", "positive-2", r.nextInt(200));
        this.doSomethingGood();
    }

    @Test
    public void runFailure() throws Exception {
        LOG.info("Sample failure case");
        Assert.fail((String)"case failed");
    }

    @Test
    public void runExternalId() throws Exception {
        LOG.info("Sample external id case, set to aaa");
        this.setExternalId("aaa");
        Random r = new Random();
        this.putResultMetric("JUnit4", "external-id-1", r.nextInt(100));
        this.putResultMetric("JUnit4", "external-id-2", r.nextInt(100));
        this.putResultMetric("JUnit4", "external-id-3", r.nextInt(100));
        this.putResultMetric("JUnit4", "external-id-4", r.nextInt(400));
        this.putResultMetric("JUnit4", "external-id-5", r.nextInt(100));
        this.putResultMetric("JUnit4", "external-id-6", r.nextInt(100));
        this.putResultMetric("JUnit4", "external-id-7", r.nextInt(100));
        this.putResultMetric("JUnit4", "external-id-8", r.nextInt(800));
        this.doSomethingGood();
    }

    @Test
    @Priority(level=0)
    public void runNegative() throws Exception {
        LOG.info("Sample negative case");
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage("something bad");
        Thread.sleep(3000L);
        this.putResultMetric("JUnit4", "negative", new Random().nextInt(100));
        this.doSomethingBad();
    }

    @Test
    @Priority(level=1)
    public void runNegativeAgain() throws Exception {
        LOG.info("Sample negative case again");
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage("Cannot resolve xyz");
        Thread.sleep(1000L);
        this.doSomethingBadAgain();
    }

    @Test
    public void runMultiple() throws Exception {
        LOG.info("Sample multiple-result case");
        this.doSomething();
        ExecutionResult er = ExecutionResult.newMultiple();
        int total = 118;
        int pass = new Random().nextInt(9) + 110;
        LOG.debug("Mark case as {}", (Object)(pass == total ? "PASS" : "FAIL"));
        er.setPass(pass);
        er.setFail(total - pass);
        this.setExecutionResult(er);
    }

    @Test
    @CaseDataProvider(klass=SampleData.class)
    public void runDataProvider() throws Exception {
        SampleData d = this.getCaseData(SampleData.class);
        LOG.debug("case data '{}'", (Object)d.caseParameter);
        Thread.sleep(500L);
    }

    @Test
    @CaseDataProvider(klass=CaseIterationData.class, method="useIterations", parameter="3")
    public void runIterations() throws Exception {
        LOG.debug("case iteration {}", (Object)new RandomStringGenerator.Builder().withinRange(97, 122).build().generate(10));
        Thread.sleep(500L);
        Assert.assertEquals((long)0L, (long)(System.currentTimeMillis() % 2L));
    }

    @Test
    public void runCasePlaceholderForNotReadyFeature() throws Exception {
        Thread.sleep(500L);
        super.markAsToBeImplemented();
    }

    @Test
    public void runRequeue() throws Exception {
        LOG.info("Sample requeue case");
        if (System.currentTimeMillis() % 2L == 0L) {
            LOG.info("requeue case");
            this.requeue();
        } else {
            LOG.info("not requeue case");
        }
    }

    private void doSomethingGood() throws IOException {
        LOG.info("Do something good");
    }

    private void doSomething() throws IOException, InterruptedException {
        LOG.info("Do something");
        Thread.sleep(1000L);
    }

    private void doSomethingBad() throws IOException {
        LOG.info("Do something bad");
        throw new IOException("something bad");
    }

    private void doSomethingBadAgain() throws IOException {
        LOG.info("Do something bad again");
        throw new IOException("Cannot resolve xyz");
    }
}

