// auto-generated by sbt-boilerplate
/**
 * Copyright (C) 2014 Lightbend Inc. <http://www.lightbend.com>
 */
package akka.stream.javadsl

import akka.stream._
import akka.stream.scaladsl
import akka.japi.function
import akka.NotUsed

/**
 * Combine the elements of multiple streams into a stream of combined elements using a combiner function.
 *
 * '''Emits when''' all of the inputs has an element available
 *
 * '''Backpressures when''' downstream backpressures
 *
 * '''Completes when''' any upstream completes
 *
 * '''Cancels when''' downstream cancels
 */
object ZipWith {

  /**
   * Create a new `ZipWith` vertex with the specified input types and zipping-function `f`.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create[A, B, Out](f: function.Function2[A, B, Out]): Graph[FanInShape2[A, B, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 3 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create3[T1, T2, T3, Out](f: function.Function3[T1, T2, T3, Out]): Graph[FanInShape3[T1, T2, T3, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 4 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create4[T1, T2, T3, T4, Out](f: function.Function4[T1, T2, T3, T4, Out]): Graph[FanInShape4[T1, T2, T3, T4, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 5 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create5[T1, T2, T3, T4, T5, Out](f: function.Function5[T1, T2, T3, T4, T5, Out]): Graph[FanInShape5[T1, T2, T3, T4, T5, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 6 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create6[T1, T2, T3, T4, T5, T6, Out](f: function.Function6[T1, T2, T3, T4, T5, T6, Out]): Graph[FanInShape6[T1, T2, T3, T4, T5, T6, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 7 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create7[T1, T2, T3, T4, T5, T6, T7, Out](f: function.Function7[T1, T2, T3, T4, T5, T6, T7, Out]): Graph[FanInShape7[T1, T2, T3, T4, T5, T6, T7, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 8 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create8[T1, T2, T3, T4, T5, T6, T7, T8, Out](f: function.Function8[T1, T2, T3, T4, T5, T6, T7, T8, Out]): Graph[FanInShape8[T1, T2, T3, T4, T5, T6, T7, T8, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 9 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create9[T1, T2, T3, T4, T5, T6, T7, T8, T9, Out](f: function.Function9[T1, T2, T3, T4, T5, T6, T7, T8, T9, Out]): Graph[FanInShape9[T1, T2, T3, T4, T5, T6, T7, T8, T9, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 10 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, Out](f: function.Function10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, Out]): Graph[FanInShape10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 11 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, Out](f: function.Function11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, Out]): Graph[FanInShape11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 12 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, Out](f: function.Function12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, Out]): Graph[FanInShape12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 13 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, Out](f: function.Function13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, Out]): Graph[FanInShape13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 14 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, Out](f: function.Function14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, Out]): Graph[FanInShape14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 15 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, Out](f: function.Function15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, Out]): Graph[FanInShape15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 16 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, Out](f: function.Function16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, Out]): Graph[FanInShape16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 17 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, Out](f: function.Function17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, Out]): Graph[FanInShape17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 18 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, Out](f: function.Function18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, Out]): Graph[FanInShape18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 19 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, Out](f: function.Function19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, Out]): Graph[FanInShape19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

  /**
   * Create a new `ZipWith` specialized for 20 inputs.
   *
   * @param f zipping-function from the input values to the output value
   * @param attributes optional attributes for this vertex
   */
  def create20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, Out](f: function.Function20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, Out]): Graph[FanInShape20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, Out], NotUsed] =
    scaladsl.ZipWith(f.apply _)

}
