/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl;

import akka.stream.impl.CancelledSubscription$;
import akka.stream.impl.ReactiveStreamsCompliance;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class ReactiveStreamsCompliance$ {
    public static ReactiveStreamsCompliance$ MODULE$;

    static {
        new ReactiveStreamsCompliance$();
    }

    public final String CanNotSubscribeTheSameSubscriberMultipleTimes() {
        return "can not subscribe the same subscriber multiple times (see reactive-streams specification, rules 1.10 and 2.12)";
    }

    public final String SupportsOnlyASingleSubscriber() {
        return "only supports one subscriber (which is allowed, see reactive-streams specification, rule 1.12)";
    }

    public final String NumberOfElementsInRequestMustBePositiveMsg() {
        return "The number of requested elements must be > 0 (see reactive-streams specification, rule 3.9)";
    }

    public final String SubscriberMustNotBeNullMsg() {
        return "Subscriber must not be null, rule 1.9";
    }

    public final String ExceptionMustNotBeNullMsg() {
        return "Exception must not be null, rule 2.13";
    }

    public final String ElementMustNotBeNullMsg() {
        return "Element must not be null, rule 2.13";
    }

    public final String SubscriptionMustNotBeNullMsg() {
        return "Subscription must not be null, rule 2.13";
    }

    public final Throwable numberOfElementsInRequestMustBePositiveException() {
        return new IllegalArgumentException("The number of requested elements must be > 0 (see reactive-streams specification, rule 3.9)");
    }

    public final Throwable canNotSubscribeTheSameSubscriberMultipleTimesException() {
        return new IllegalStateException("can not subscribe the same subscriber multiple times (see reactive-streams specification, rules 1.10 and 2.12)");
    }

    public final Throwable subscriberMustNotBeNullException() {
        return new NullPointerException("Subscriber must not be null, rule 1.9");
    }

    public final Throwable exceptionMustNotBeNullException() {
        return new NullPointerException("Exception must not be null, rule 2.13");
    }

    public final Throwable elementMustNotBeNullException() {
        return new NullPointerException("Element must not be null, rule 2.13");
    }

    public final Throwable subscriptionMustNotBeNullException() {
        return new NullPointerException("Subscription must not be null, rule 2.13");
    }

    public final <T> void rejectDuplicateSubscriber(Subscriber<T> subscriber) {
        this.tryOnError(subscriber, this.canNotSubscribeTheSameSubscriberMultipleTimesException());
    }

    public final <T> void rejectAdditionalSubscriber(Subscriber<T> subscriber, String rejector) {
        this.tryOnSubscribe(subscriber, CancelledSubscription$.MODULE$);
        this.tryOnError(subscriber, new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rejector, "only supports one subscriber (which is allowed, see reactive-streams specification, rule 1.12)"}))));
    }

    public final <T> void rejectDueToNonPositiveDemand(Subscriber<T> subscriber) {
        this.tryOnError(subscriber, this.numberOfElementsInRequestMustBePositiveException());
    }

    public final <T> void requireNonNullSubscriber(Subscriber<T> subscriber) {
        if (subscriber == null) {
            throw this.subscriberMustNotBeNullException();
        }
    }

    public final void requireNonNullException(Throwable cause) {
        if (cause == null) {
            throw this.exceptionMustNotBeNullException();
        }
    }

    public final <T> void requireNonNullElement(T element) {
        if (element == null) {
            throw this.elementMustNotBeNullException();
        }
    }

    public final void requireNonNullSubscription(Subscription subscription) {
        if (subscription == null) {
            throw this.subscriptionMustNotBeNullException();
        }
    }

    public final <T> void tryOnError(Subscriber<T> subscriber, Throwable error) {
        BoxedUnit boxedUnit;
        Throwable throwable = error;
        if (throwable instanceof ReactiveStreamsCompliance.SpecViolation) {
            ReactiveStreamsCompliance.SpecViolation specViolation = (ReactiveStreamsCompliance.SpecViolation)((Object)throwable);
            throw new IllegalStateException("It is not legal to try to signal onError with a SpecViolation", (Throwable)((Object)specViolation));
        }
        try {
            subscriber.onError(throwable);
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                throw new ReactiveStreamsCompliance.SignalThrewException(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(subscriber), ".onError"), t);
            }
            throw throwable2;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public final <T> void tryOnNext(Subscriber<T> subscriber, T element) {
        this.requireNonNullElement(element);
        try {
            subscriber.onNext(element);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                throw new ReactiveStreamsCompliance.SignalThrewException(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(subscriber), ".onNext"), t);
            }
            throw throwable;
        }
    }

    public final <T> void tryOnSubscribe(Subscriber<T> subscriber, Subscription subscription) {
        try {
            subscriber.onSubscribe(subscription);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                throw new ReactiveStreamsCompliance.SignalThrewException(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(subscriber), ".onSubscribe"), t);
            }
            throw throwable;
        }
    }

    public final <T> void tryOnComplete(Subscriber<T> subscriber) {
        try {
            subscriber.onComplete();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                throw new ReactiveStreamsCompliance.SignalThrewException(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(subscriber), ".onComplete"), t);
            }
            throw throwable;
        }
    }

    public final void tryRequest(Subscription subscription, long demand) {
        try {
            subscription.request(demand);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                throw new ReactiveStreamsCompliance.SignalThrewException("It is illegal to throw exceptions from request(), rule 3.16", t);
            }
            throw throwable;
        }
    }

    public final void tryCancel(Subscription subscription) {
        try {
            subscription.cancel();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                throw new ReactiveStreamsCompliance.SignalThrewException("It is illegal to throw exceptions from cancel(), rule 3.15", t);
            }
            throw throwable;
        }
    }

    private ReactiveStreamsCompliance$() {
        MODULE$ = this;
    }
}

