/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt.v2;

import com.jakewharton.retrofit.Ok3Client;
import com.uwetrottmann.trakt.v2.TraktErrorHandler;
import com.uwetrottmann.trakt.v2.TraktHttpClient;
import com.uwetrottmann.trakt.v2.TraktV2Helper;
import com.uwetrottmann.trakt.v2.Utils;
import com.uwetrottmann.trakt.v2.services.Calendars;
import com.uwetrottmann.trakt.v2.services.Checkin;
import com.uwetrottmann.trakt.v2.services.Comments;
import com.uwetrottmann.trakt.v2.services.Episodes;
import com.uwetrottmann.trakt.v2.services.Genres;
import com.uwetrottmann.trakt.v2.services.Movies;
import com.uwetrottmann.trakt.v2.services.People;
import com.uwetrottmann.trakt.v2.services.Recommendations;
import com.uwetrottmann.trakt.v2.services.Search;
import com.uwetrottmann.trakt.v2.services.Seasons;
import com.uwetrottmann.trakt.v2.services.Shows;
import com.uwetrottmann.trakt.v2.services.Sync;
import com.uwetrottmann.trakt.v2.services.Users;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class TraktV2 {
    public static final String SITE_URL = "https://trakt.tv";
    public static final String API_URL = "https://api-v2launch.trakt.tv";
    public static final String HEADER_TRAKT_API_VERSION_2 = "2";
    public static final String HEADER_CONTENT_TYPE_JSON = "application/json";
    public static final String OAUTH2_AUTHORIZATION_URL = "https://trakt.tv/oauth/authorize";
    public static final String OAUTH2_TOKEN_URL = "https://trakt.tv/oauth/token";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_TRAKT_API_KEY = "trakt-api-key";
    public static final String HEADER_TRAKT_API_VERSION = "trakt-api-version";
    private String apiKey;
    private String accessToken;
    private boolean isDebug;
    private RestAdapter restAdapter;

    public static OAuthClientRequest getAuthorizationRequest(String clientId, String redirectUri, String state) throws OAuthSystemException {
        return OAuthClientRequest.authorizationLocation((String)OAUTH2_AUTHORIZATION_URL).setResponseType(ResponseType.CODE.toString()).setClientId(clientId).setRedirectURI(redirectUri).setState(state).buildQueryMessage();
    }

    public static OAuthClientRequest getAccessTokenRequest(String clientId, String clientSecret, String redirectUri, String authCode) throws OAuthSystemException {
        return OAuthClientRequest.tokenLocation((String)OAUTH2_TOKEN_URL).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authCode).setRedirectURI(redirectUri).setClientId(clientId).setClientSecret(clientSecret).buildQueryMessage();
    }

    public static OAuthAccessTokenResponse getAccessToken(String clientId, String clientSecret, String redirectUri, String authCode) throws OAuthSystemException, OAuthProblemException {
        OAuthClientRequest request = TraktV2.getAccessTokenRequest(clientId, clientSecret, redirectUri, authCode);
        OAuthClient client = new OAuthClient((HttpClient)new TraktHttpClient());
        return client.accessToken(request);
    }

    public static OAuthClientRequest getAccessTokenRefreshRequest(String clientId, String clientSecret, String redirectUri, String refreshToken) throws OAuthSystemException {
        return OAuthClientRequest.tokenLocation((String)OAUTH2_TOKEN_URL).setGrantType(GrantType.REFRESH_TOKEN).setRefreshToken(refreshToken).setRedirectURI(redirectUri).setClientId(clientId).setClientSecret(clientSecret).buildQueryMessage();
    }

    public static OAuthAccessTokenResponse refreshAccessToken(String clientId, String clientSecret, String redirectUri, String refreshToken) throws OAuthSystemException, OAuthProblemException {
        OAuthClientRequest request = TraktV2.getAccessTokenRefreshRequest(clientId, clientSecret, redirectUri, refreshToken);
        OAuthClient client = new OAuthClient((HttpClient)new TraktHttpClient());
        return client.accessToken(request);
    }

    public TraktV2 setApiKey(String apiKey) {
        this.apiKey = apiKey;
        this.restAdapter = null;
        return this;
    }

    public TraktV2 setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        this.restAdapter = null;
        return this;
    }

    public TraktV2 setIsDebug(boolean isDebug) {
        this.isDebug = isDebug;
        if (this.restAdapter != null) {
            this.restAdapter.setLogLevel(isDebug ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE);
        }
        return this;
    }

    protected RestAdapter.Builder newRestAdapterBuilder() {
        return new RestAdapter.Builder();
    }

    protected RestAdapter getRestAdapter() {
        if (this.restAdapter == null) {
            RestAdapter.Builder builder = this.newRestAdapterBuilder();
            builder.setEndpoint(API_URL);
            builder.setClient((Client)new Ok3Client(Utils.createOkHttpClient()));
            builder.setConverter((Converter)new GsonConverter(TraktV2Helper.getGsonBuilder().create()));
            builder.setRequestInterceptor(new RequestInterceptor(){

                public void intercept(RequestInterceptor.RequestFacade request) {
                    if (TraktV2.this.accessToken != null && TraktV2.this.accessToken.length() != 0) {
                        request.addHeader(TraktV2.HEADER_AUTHORIZATION, "Bearer " + TraktV2.this.accessToken);
                    }
                    request.addHeader(TraktV2.HEADER_CONTENT_TYPE, TraktV2.HEADER_CONTENT_TYPE_JSON);
                    request.addHeader(TraktV2.HEADER_TRAKT_API_KEY, TraktV2.this.apiKey);
                    request.addHeader(TraktV2.HEADER_TRAKT_API_VERSION, TraktV2.HEADER_TRAKT_API_VERSION_2);
                }
            });
            builder.setErrorHandler((ErrorHandler)new TraktErrorHandler());
            if (this.isDebug) {
                builder.setLogLevel(RestAdapter.LogLevel.FULL);
            }
            this.restAdapter = builder.build();
        }
        return this.restAdapter;
    }

    public Calendars calendars() {
        return (Calendars)this.getRestAdapter().create(Calendars.class);
    }

    public Checkin checkin() {
        return (Checkin)this.getRestAdapter().create(Checkin.class);
    }

    public Comments comments() {
        return (Comments)this.getRestAdapter().create(Comments.class);
    }

    public Genres genres() {
        return (Genres)this.getRestAdapter().create(Genres.class);
    }

    public Movies movies() {
        return (Movies)this.getRestAdapter().create(Movies.class);
    }

    public People people() {
        return (People)this.getRestAdapter().create(People.class);
    }

    public Recommendations recommendations() {
        return (Recommendations)this.getRestAdapter().create(Recommendations.class);
    }

    public Search search() {
        return (Search)this.getRestAdapter().create(Search.class);
    }

    public Shows shows() {
        return (Shows)this.getRestAdapter().create(Shows.class);
    }

    public Seasons seasons() {
        return (Seasons)this.getRestAdapter().create(Seasons.class);
    }

    public Episodes episodes() {
        return (Episodes)this.getRestAdapter().create(Episodes.class);
    }

    public Sync sync() {
        return (Sync)this.getRestAdapter().create(Sync.class);
    }

    public Users users() {
        return (Users)this.getRestAdapter().create(Users.class);
    }
}

