/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt.v2.enums;

import com.uwetrottmann.trakt.v2.enums.TraktEnum;
import java.util.HashMap;
import java.util.Map;

public enum Status implements TraktEnum
{
    ENDED("ended"),
    RETURNING("returning series"),
    CANCELED("canceled"),
    IN_PRODUCTION("in production");

    private final String value;
    private static final Map<String, Status> STRING_MAPPING;

    private Status(String value) {
        this.value = value;
    }

    public static Status fromValue(String value) {
        return STRING_MAPPING.get(value.toUpperCase());
    }

    @Override
    public String toString() {
        return this.value;
    }

    static {
        STRING_MAPPING = new HashMap<String, Status>();
        for (Status via : Status.values()) {
            STRING_MAPPING.put(via.toString().toUpperCase(), via);
        }
    }
}

