/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt.v2.exceptions;

import com.uwetrottmann.trakt.v2.entities.CheckinError;
import org.joda.time.DateTime;
import retrofit.RetrofitError;

public class CheckinInProgressException
extends Exception {
    private final DateTime expiresAt;

    public CheckinInProgressException(RetrofitError cause) {
        super("A checkin is already in progress", (Throwable)cause);
        Object body = null;
        try {
            body = cause.getBodyAs(CheckinError.class);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (body != null) {
            CheckinError error = (CheckinError)body;
            this.expiresAt = error.expires_at;
        } else {
            this.expiresAt = null;
        }
    }

    public DateTime getExpiresAt() {
        return this.expiresAt;
    }
}

