/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt.v2.services;

import com.uwetrottmann.trakt.v2.entities.BaseShow;
import com.uwetrottmann.trakt.v2.entities.Comment;
import com.uwetrottmann.trakt.v2.entities.Credits;
import com.uwetrottmann.trakt.v2.entities.Ratings;
import com.uwetrottmann.trakt.v2.entities.Show;
import com.uwetrottmann.trakt.v2.entities.Translation;
import com.uwetrottmann.trakt.v2.entities.TrendingShow;
import com.uwetrottmann.trakt.v2.enums.Extended;
import com.uwetrottmann.trakt.v2.exceptions.OAuthUnauthorizedException;
import java.util.List;
import retrofit.http.GET;
import retrofit.http.Path;
import retrofit.http.Query;

public interface Shows {
    @GET(value="/shows/popular")
    public List<Show> popular(@Query(value="page") Integer var1, @Query(value="limit") Integer var2, @Query(value="extended", encodeValue=false) Extended var3);

    @GET(value="/shows/trending")
    public List<TrendingShow> trending(@Query(value="page") Integer var1, @Query(value="limit") Integer var2, @Query(value="extended", encodeValue=false) Extended var3);

    @GET(value="/shows/{id}")
    public Show summary(@Path(value="id") String var1, @Query(value="extended", encodeValue=false) Extended var2);

    @GET(value="/shows/{id}/translations")
    public List<Translation> translations(@Path(value="id") String var1);

    @GET(value="/shows/{id}/translations/{language}")
    public List<Translation> translation(@Path(value="id") String var1, @Path(value="language") String var2);

    @GET(value="/shows/{id}/comments")
    public List<Comment> comments(@Path(value="id") String var1, @Query(value="page") Integer var2, @Query(value="limit") Integer var3, @Query(value="extended", encodeValue=false) Extended var4);

    @GET(value="/shows/{id}/progress/collection")
    public BaseShow collectedProgress(@Path(value="id") String var1, @Query(value="hidden") Boolean var2, @Query(value="specials") Boolean var3, @Query(value="extended", encodeValue=false) Extended var4) throws OAuthUnauthorizedException;

    @GET(value="/shows/{id}/progress/watched")
    public BaseShow watchedProgress(@Path(value="id") String var1, @Query(value="hidden") Boolean var2, @Query(value="specials") Boolean var3, @Query(value="extended", encodeValue=false) Extended var4) throws OAuthUnauthorizedException;

    @GET(value="/shows/{id}/people")
    public Credits people(@Path(value="id") String var1);

    @GET(value="/shows/{id}/ratings")
    public Ratings ratings(@Path(value="id") String var1);
}

