/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt.v2.services;

import com.uwetrottmann.trakt.v2.entities.BaseMovie;
import com.uwetrottmann.trakt.v2.entities.BaseShow;
import com.uwetrottmann.trakt.v2.entities.LastActivities;
import com.uwetrottmann.trakt.v2.entities.RatedEpisode;
import com.uwetrottmann.trakt.v2.entities.RatedMovie;
import com.uwetrottmann.trakt.v2.entities.RatedSeason;
import com.uwetrottmann.trakt.v2.entities.RatedShow;
import com.uwetrottmann.trakt.v2.entities.SyncItems;
import com.uwetrottmann.trakt.v2.entities.SyncResponse;
import com.uwetrottmann.trakt.v2.entities.WatchlistedEpisode;
import com.uwetrottmann.trakt.v2.entities.WatchlistedSeason;
import com.uwetrottmann.trakt.v2.enums.Extended;
import com.uwetrottmann.trakt.v2.enums.RatingsFilter;
import com.uwetrottmann.trakt.v2.exceptions.OAuthUnauthorizedException;
import java.util.List;
import retrofit.http.Body;
import retrofit.http.GET;
import retrofit.http.POST;
import retrofit.http.Path;
import retrofit.http.Query;

public interface Sync {
    @GET(value="/sync/last_activities")
    public LastActivities lastActivities() throws OAuthUnauthorizedException;

    @GET(value="/sync/collection/movies")
    public List<BaseMovie> collectionMovies(@Query(value="extended", encodeValue=false) Extended var1) throws OAuthUnauthorizedException;

    @GET(value="/sync/collection/shows")
    public List<BaseShow> collectionShows(@Query(value="extended", encodeValue=false) Extended var1) throws OAuthUnauthorizedException;

    @POST(value="/sync/collection")
    public SyncResponse addItemsToCollection(@Body SyncItems var1) throws OAuthUnauthorizedException;

    @POST(value="/sync/collection/remove")
    public SyncResponse deleteItemsFromCollection(@Body SyncItems var1) throws OAuthUnauthorizedException;

    @GET(value="/sync/watched/movies")
    public List<BaseMovie> watchedMovies(@Query(value="extended", encodeValue=false) Extended var1) throws OAuthUnauthorizedException;

    @GET(value="/sync/watched/shows")
    public List<BaseShow> watchedShows(@Query(value="extended", encodeValue=false) Extended var1) throws OAuthUnauthorizedException;

    @POST(value="/sync/history")
    public SyncResponse addItemsToWatchedHistory(@Body SyncItems var1) throws OAuthUnauthorizedException;

    @POST(value="/sync/history/remove")
    public SyncResponse deleteItemsFromWatchedHistory(@Body SyncItems var1) throws OAuthUnauthorizedException;

    @GET(value="/sync/ratings/movies{rating}")
    public List<RatedMovie> ratingsMovies(@Path(value="rating", encode=false) RatingsFilter var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/sync/ratings/shows{rating}")
    public List<RatedShow> ratingsShows(@Path(value="rating", encode=false) RatingsFilter var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/sync/ratings/seasons{rating}")
    public List<RatedSeason> ratingsSeasons(@Path(value="rating", encode=false) RatingsFilter var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/sync/ratings/episodes{rating}")
    public List<RatedEpisode> ratingsEpisodes(@Path(value="rating", encode=false) RatingsFilter var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @POST(value="/sync/ratings")
    public SyncResponse addRatings(@Body SyncItems var1) throws OAuthUnauthorizedException;

    @POST(value="/sync/ratings/remove")
    public SyncResponse deleteRatings(@Body SyncItems var1) throws OAuthUnauthorizedException;

    @GET(value="/sync/watchlist/movies")
    public List<BaseMovie> watchlistMovies(@Query(value="extended", encodeValue=false) Extended var1) throws OAuthUnauthorizedException;

    @GET(value="/sync/watchlist/shows")
    public List<BaseShow> watchlistShows(@Query(value="extended", encodeValue=false) Extended var1) throws OAuthUnauthorizedException;

    @GET(value="/sync/watchlist/seasons")
    public List<WatchlistedSeason> watchlistSeasons(@Query(value="extended", encodeValue=false) Extended var1) throws OAuthUnauthorizedException;

    @GET(value="/sync/watchlist/episodes")
    public List<WatchlistedEpisode> watchlistEpisodes(@Query(value="extended", encodeValue=false) Extended var1) throws OAuthUnauthorizedException;

    @POST(value="/sync/watchlist")
    public SyncResponse addItemsToWatchlist(@Body SyncItems var1) throws OAuthUnauthorizedException;

    @POST(value="/sync/watchlist/remove")
    public SyncResponse deleteItemsFromWatchlist(@Body SyncItems var1) throws OAuthUnauthorizedException;
}

