/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt.v2.services;

import com.uwetrottmann.trakt.v2.entities.BaseMovie;
import com.uwetrottmann.trakt.v2.entities.BaseShow;
import com.uwetrottmann.trakt.v2.entities.Followed;
import com.uwetrottmann.trakt.v2.entities.Follower;
import com.uwetrottmann.trakt.v2.entities.Friend;
import com.uwetrottmann.trakt.v2.entities.HistoryEntry;
import com.uwetrottmann.trakt.v2.entities.ListEntry;
import com.uwetrottmann.trakt.v2.entities.RatedEpisode;
import com.uwetrottmann.trakt.v2.entities.RatedMovie;
import com.uwetrottmann.trakt.v2.entities.RatedSeason;
import com.uwetrottmann.trakt.v2.entities.RatedShow;
import com.uwetrottmann.trakt.v2.entities.Settings;
import com.uwetrottmann.trakt.v2.entities.SyncItems;
import com.uwetrottmann.trakt.v2.entities.SyncResponse;
import com.uwetrottmann.trakt.v2.entities.User;
import com.uwetrottmann.trakt.v2.entities.Username;
import com.uwetrottmann.trakt.v2.entities.WatchlistedEpisode;
import com.uwetrottmann.trakt.v2.entities.WatchlistedSeason;
import com.uwetrottmann.trakt.v2.enums.Extended;
import com.uwetrottmann.trakt.v2.enums.HistoryType;
import com.uwetrottmann.trakt.v2.enums.RatingsFilter;
import com.uwetrottmann.trakt.v2.exceptions.OAuthUnauthorizedException;
import java.util.List;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.GET;
import retrofit.http.POST;
import retrofit.http.PUT;
import retrofit.http.Path;
import retrofit.http.Query;

public interface Users {
    @GET(value="/users/settings")
    public Settings settings() throws OAuthUnauthorizedException;

    @GET(value="/users/{username}")
    public User profile(@Path(value="username") Username var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/collection/movies")
    public List<BaseMovie> collectionMovies(@Path(value="username") Username var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/collection/shows")
    public List<BaseShow> collectionShows(@Path(value="username") Username var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/lists")
    public List<com.uwetrottmann.trakt.v2.entities.List> lists(@Path(value="username") Username var1) throws OAuthUnauthorizedException;

    @POST(value="/users/{username}/lists")
    public com.uwetrottmann.trakt.v2.entities.List createList(@Path(value="username") Username var1, @Body com.uwetrottmann.trakt.v2.entities.List var2) throws OAuthUnauthorizedException;

    @PUT(value="/users/{username}/lists/{id}")
    public com.uwetrottmann.trakt.v2.entities.List updateList(@Path(value="username") Username var1, @Path(value="id") String var2, @Body com.uwetrottmann.trakt.v2.entities.List var3) throws OAuthUnauthorizedException;

    @DELETE(value="/users/{username}/lists/{id}")
    public Response deleteList(@Path(value="username") Username var1, @Path(value="id") String var2) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/lists/{id}/items")
    public List<ListEntry> listItems(@Path(value="username") Username var1, @Path(value="id") String var2, @Query(value="extended", encodeValue=false) Extended var3) throws OAuthUnauthorizedException;

    @POST(value="/users/{username}/lists/{id}/items")
    public SyncResponse addListItems(@Path(value="username") Username var1, @Path(value="id") String var2, @Body SyncItems var3) throws OAuthUnauthorizedException;

    @POST(value="/users/{username}/lists/{id}/items/remove")
    public SyncResponse deleteListItems(@Path(value="username") Username var1, @Path(value="id") String var2, @Body SyncItems var3) throws OAuthUnauthorizedException;

    @POST(value="/users/{username}/follow")
    public Followed follow(@Path(value="username") Username var1) throws OAuthUnauthorizedException;

    @DELETE(value="/users/{username}/follow")
    public Response unfollow(@Path(value="username") Username var1) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/followers")
    public List<Follower> followers(@Path(value="username") Username var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/following")
    public List<Follower> following(@Path(value="username") Username var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/friends")
    public List<Friend> friends(@Path(value="username") Username var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/history")
    public List<HistoryEntry> history(@Path(value="username") Username var1, @Query(value="page") Integer var2, @Query(value="limit") Integer var3, @Query(value="extended", encodeValue=false) Extended var4) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/history/{type}")
    public List<HistoryEntry> history(@Path(value="username") Username var1, @Path(value="type") HistoryType var2, @Query(value="page") Integer var3, @Query(value="limit") Integer var4, @Query(value="extended", encodeValue=false) Extended var5) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/history/{type}/{id}")
    public List<HistoryEntry> history(@Path(value="username") Username var1, @Path(value="type") HistoryType var2, @Path(value="id") int var3, @Query(value="page") Integer var4, @Query(value="limit") Integer var5, @Query(value="extended", encodeValue=false) Extended var6) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/ratings/movies{rating}")
    public List<RatedMovie> ratingsMovies(@Path(value="username") Username var1, @Path(value="rating", encode=false) RatingsFilter var2, @Query(value="extended", encodeValue=false) Extended var3) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/ratings/shows{rating}")
    public List<RatedShow> ratingsShows(@Path(value="username") Username var1, @Path(value="rating", encode=false) RatingsFilter var2, @Query(value="extended", encodeValue=false) Extended var3) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/ratings/seasons{rating}")
    public List<RatedSeason> ratingsSeasons(@Path(value="username") Username var1, @Path(value="rating", encode=false) RatingsFilter var2, @Query(value="extended", encodeValue=false) Extended var3) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/ratings/episodes{rating}")
    public List<RatedEpisode> ratingsEpisodes(@Path(value="username") Username var1, @Path(value="rating", encode=false) RatingsFilter var2, @Query(value="extended", encodeValue=false) Extended var3) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/watchlist/movies")
    public List<BaseMovie> watchlistMovies(@Path(value="username") Username var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/watchlist/shows")
    public List<BaseShow> watchlistShows(@Path(value="username") Username var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/watchlist/seasons")
    public List<WatchlistedSeason> watchlistSeasons(@Path(value="username") Username var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/watchlist/episodes")
    public List<WatchlistedEpisode> watchlistEpisodes(@Path(value="username") Username var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/watched/movies")
    public List<BaseMovie> watchedMovies(@Path(value="username") Username var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;

    @GET(value="/users/{username}/watched/shows")
    public List<BaseShow> watchedShows(@Path(value="username") Username var1, @Query(value="extended", encodeValue=false) Extended var2) throws OAuthUnauthorizedException;
}

