/*
 * Decompiled with CFR 0.152.
 */
package com.comnon.geolocate;

import com.comnon.geolocate.GeoIPData;
import com.github.davidmoten.geo.GeoHash;
import com.google.common.base.Strings;
import com.maxmind.db.CHMCache;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Subdivision;
import java.io.File;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIPService {
    private static final Logger logger = LoggerFactory.getLogger(GeoIPService.class);
    private static DatabaseReader reader;
    private static String DEFAULT_GEODB_FILE;

    public static void loadGeoIpData() {
        GeoIPService.loadGeoIpData(DEFAULT_GEODB_FILE);
    }

    public static void loadGeoIpData(String geoDbFile) {
        try {
            File geodb = new File(geoDbFile);
            if (!geodb.exists()) {
                logger.info("GeoDB[{}] not exist", (Object)geoDbFile);
            } else {
                reader = new DatabaseReader.Builder(geodb).withCache((NodeCache)new CHMCache()).build();
            }
        }
        catch (Exception e) {
            logger.error("Load GeoDB[{}] failed! ex[{}]", (Object)geoDbFile, (Object)e);
        }
    }

    public static GeoIPData getGeoIPData(String ip) {
        if (reader == null) {
            logger.warn("Geo database is not init, please check");
            return null;
        }
        if (ip == null) {
            return null;
        }
        try {
            Location location;
            City city;
            Subdivision subdivision;
            InetAddress ipAddress = InetAddress.getByName(ip);
            CityResponse response = reader.city(ipAddress);
            if (response == null) {
                logger.error("Can not get geo info by ip[{}]", (Object)ip);
                return null;
            }
            GeoIPData geoIPData = new GeoIPData();
            Country country = response.getCountry();
            if (country != null) {
                geoIPData.setCountryCode(country.getIsoCode());
            }
            if ((subdivision = response.getMostSpecificSubdivision()) != null) {
                geoIPData.setStateCode(subdivision.getIsoCode());
            }
            if ((city = response.getCity()) != null) {
                geoIPData.setCityName(city.getName());
            }
            if ((location = response.getLocation()) != null) {
                try {
                    String geoHash = GeoHash.encodeHash((double)location.getLatitude(), (double)location.getLongitude());
                    geoIPData.setLatitude(location.getLatitude());
                    geoIPData.setLongitude(location.getLongitude());
                    geoIPData.setGeohash(geoHash);
                }
                catch (Exception e) {
                    logger.warn("Error in convert geoHash: %s", (Object)ip);
                }
            }
            return geoIPData;
        }
        catch (Exception e) {
            logger.error("Error in getGeoIPData: %s", (Object)ip);
            return null;
        }
    }

    public static String getCountry(String ip) {
        if (Strings.isNullOrEmpty((String)ip)) {
            return ip;
        }
        if (reader == null) {
            logger.info("GeoDB not Init ip={}", (Object)ip);
            return "";
        }
        try {
            InetAddress ipAddress = InetAddress.getByName(ip);
            CityResponse response = reader.city(ipAddress);
            if (response == null) {
                logger.error("Can not get geo info by ip[{}]", (Object)ip);
                return null;
            }
            Country country = response.getCountry();
            if (country != null) {
                return country.getIsoCode();
            }
        }
        catch (Exception e) {
            logger.error("Error in getGeoIPData: {}", (Object)ip);
            return null;
        }
        return "";
    }

    static {
        DEFAULT_GEODB_FILE = "cfg/GeoLite2-City.mmdb";
    }
}

