/*
 * Decompiled with CFR 0.152.
 */
package com.comnon.lac;

import com.comnon.lac.LACConfig;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import common.config.tools.config.loader.json.JsonSerialize;
import common.config.tools.file.monitor.JsonChangeListener;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LACConfigLoadListener
extends JsonChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(LACConfigLoadListener.class);
    private LACConfig aclConfig;
    private String fileName = "livetv-lac.json";

    public LACConfigLoadListener(LACConfig aclConfig, String fileName) {
        super(false, (Map)Maps.newHashMap(), (Map)Maps.newHashMap());
        this.aclConfig = aclConfig;
        if (!Strings.isNullOrEmpty((String)fileName)) {
            this.fileName = fileName;
        }
    }

    public void onFileCreate(File file) {
        this.loadACLConfig(file);
    }

    public void onFileChange(File file) {
        this.loadACLConfig(file);
    }

    private void loadACLConfig(File file) {
        String fn = FilenameUtils.getName((String)file.getName());
        if (!this.fileName.equalsIgnoreCase(fn)) {
            return;
        }
        LACConfig newACLConfig = (LACConfig)JsonSerialize.loadJson((File)file, (TypeReference)new TypeReference<LACConfig>(){});
        if (newACLConfig != null) {
            this.aclConfig.setUseACL(newACLConfig.getUseACL());
            this.aclConfig.setDidWhiteList(newACLConfig.getDidWhiteList());
            this.aclConfig.setHost(newACLConfig.getHost());
            this.aclConfig.setRegion(newACLConfig.getRegion());
            this.aclConfig.setSkipNullOrEmpty(newACLConfig.getSkipNullOrEmpty());
            logger.info("LAC Load config. [{}]", (Object)this.aclConfig.toString());
        }
    }
}

