/*
 * Decompiled with CFR 0.152.
 */
package com.comnon.lac;

import com.comnon.geolocate.GeoIPService;
import com.comnon.lac.LACConfig;
import com.comnon.lac.LACConfigBlackWhiteList;
import com.comnon.lac.LACConfigLoadListener;
import com.google.common.base.Strings;
import common.config.tools.file.monitor.IFileChangeListener;
import common.config.tools.file.monitor.SingleFileMonitor;
import org.apache.commons.io.FilenameUtils;

public class LACTools {
    private static LACConfig lacConfig = new LACConfig();

    public static void loadGeoDB(String geoDB) {
        GeoIPService.loadGeoIpData(geoDB);
    }

    public static void loaderCfg(String path, String filename, long interval) {
        new SingleFileMonitor(interval).monitorFile(path, filename, (IFileChangeListener)new LACConfigLoadListener(lacConfig, FilenameUtils.getName((String)filename))).start();
    }

    public static void loaderCfg(String filename, long interval) {
        new SingleFileMonitor(interval).monitorFile(filename, (IFileChangeListener)new LACConfigLoadListener(lacConfig, FilenameUtils.getName((String)filename))).start();
    }

    public static boolean isACLEnable() {
        return lacConfig.getUseACL() != 0;
    }

    public static boolean isHostPermit(String did, String host, String region) {
        if (lacConfig.getDidWhiteList().contains(did.toLowerCase())) {
            return true;
        }
        String hostLowerCase = Strings.nullToEmpty((String)host).toLowerCase();
        if (Strings.isNullOrEmpty((String)region)) {
            region = GeoIPService.getCountry(host);
        }
        String regionLowerCase = Strings.nullToEmpty((String)region).toLowerCase();
        LACConfigBlackWhiteList hostBWList = lacConfig.getHost();
        if (!lacConfig.isWhiteListEmpty(hostBWList) && hostBWList.getWhitelist().contains(hostLowerCase)) {
            return true;
        }
        if (!lacConfig.isBlackListEmpty(hostBWList) && hostBWList.getBlacklist().contains(hostLowerCase)) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)regionLowerCase)) {
            if (lacConfig.getSkipNullOrEmpty() == 0) {
                return false;
            }
        } else {
            LACConfigBlackWhiteList regionBWList = lacConfig.getRegion();
            if (!lacConfig.isWhiteListEmpty(regionBWList)) {
                return regionBWList.getWhitelist().contains(regionLowerCase);
            }
            if (!lacConfig.isBlackListEmpty(regionBWList)) {
                return !regionBWList.getBlacklist().contains(regionLowerCase);
            }
        }
        return true;
    }
}

