package com.valor.common.dac.client.restcall;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.client.AsyncRestTemplate;

public class RestCallAsync {
    private static Logger logger = LoggerFactory.getLogger(RestCallAsync.class);
    private static AsyncRestTemplate template = getRestClient();

    private static AsyncRestTemplate getRestClient() {
        if (template == null) {
            template = new AsyncRestTemplate(RestCallClient.AsyncHttpFactory());
//            template.setErrorHandler(new RestErrorHandler());
        }

        return template;
    }


    /**
     * Async post use AsyncRestTemplate
     *
     * @param url
     * @param request
     * @param responseType
     * @param callback
     * @param <REQ>
     * @param <RSP>
     */
    public static <REQ, RSP> void postAsync(String url, REQ request, Class<RSP> responseType,
                                            ListenableFutureCallback<ResponseEntity<RSP>> callback) {
        try {
            // set headers
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<REQ> entity = new HttpEntity<>(request, headers);

            ListenableFuture<ResponseEntity<RSP>> future = getRestClient().postForEntity(url, entity, responseType);
            future.addCallback(callback);
        } catch (Exception e) {
            logger.error("AsyncRestTemplate:{}", e);
        }
    }

    public static <REQ, RSP> ListenableFuture<ResponseEntity<RSP>> postAsync(String url, REQ request, Class<RSP> responseType) {
        try {
            // set headers
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<REQ> entity = new HttpEntity<>(request, headers);

            ListenableFuture<ResponseEntity<RSP>> future = getRestClient().postForEntity(url, entity, responseType);
            return future;
        } catch (Exception e) {
            logger.error("AsyncRestTemplate:{}", e);
        }
        return null;
    }

//    public static <REQ, RSP> void postAsync(String url, REQ request, ParameterizedTypeReference<RSP> responseType, RestCallAsyncCallback callback) {
//        if (template == null) {
//            template = new AsyncRestTemplate(RestCallClient.AsyncHttpFactory());
//        }
//
//        try {
//            // set headers
//            HttpHeaders headers = new HttpHeaders();
//            headers.setContentType(MediaType.APPLICATION_JSON);
//            HttpEntity<REQ> entity = new HttpEntity<>(request, headers);
//
//            ListenableFuture<ResponseEntity<RSP>> future = template.exchange(url, HttpMethod.POST, entity, responseType);
//            future.addCallback(callback);
//        } catch (Exception e) {
//            logger.error("AsyncRestTemplate:{}", e);
//        }
//    }

}
