/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.dac.client.restcall;

import java.io.IOException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsAsyncClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public class RestCallClient {
    private static Logger logger = LoggerFactory.getLogger(RestCallClient.class);
    private static int maxHttpConnectionTotal = 1000;
    private static int maxHttpConnectionPerRoute = 1000;
    private static int timeout = 1000;
    private static int failbackRetry = 1;

    public static void init(int maxHttpConnectionTotal, int maxHttpConnectionPerRoute, int timeout) {
        RestCallClient.maxHttpConnectionTotal = maxHttpConnectionTotal;
        RestCallClient.maxHttpConnectionPerRoute = maxHttpConnectionPerRoute;
        RestCallClient.timeout = timeout;
    }

    public static ClientHttpRequestFactory SyncHttpFactory() {
        return new HttpComponentsClientHttpRequestFactory(RestCallClient.getHttpSyncClient());
    }

    public static HttpComponentsAsyncClientHttpRequestFactory AsyncHttpFactory() {
        return new HttpComponentsAsyncClientHttpRequestFactory(RestCallClient.getHttpAsyncClient());
    }

    private static RequestConfig getRequestConfig() {
        if (timeout == 0) {
            timeout = 1000;
        }
        return RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).build();
    }

    private static PoolingHttpClientConnectionManager getConnectionManager() {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(maxHttpConnectionTotal);
        connectionManager.setDefaultMaxPerRoute(maxHttpConnectionPerRoute);
        return connectionManager;
    }

    private static HttpClient getHttpSyncClient() {
        return HttpClientBuilder.create().setDefaultRequestConfig(RestCallClient.getRequestConfig()).setConnectionManager((HttpClientConnectionManager)RestCallClient.getConnectionManager()).setRetryHandler(new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                logger.info("HttpClient failback Retry:{}:{}", (Object)executionCount, (Object)exception);
                return executionCount < failbackRetry;
            }
        }).build();
    }

    private static HttpAsyncClient getHttpAsyncClient() {
        return HttpAsyncClientBuilder.create().setDefaultRequestConfig(RestCallClient.getRequestConfig()).setMaxConnTotal(maxHttpConnectionTotal).setMaxConnPerRoute(maxHttpConnectionPerRoute).build();
    }
}

