/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.dac.client.service;

import com.google.gson.Gson;
import com.valor.common.dac.client.apimodel.request.ApiDACRequest;
import com.valor.common.dac.client.apimodel.response.ApiDACResponse;
import com.valor.common.dac.client.restcall.RestCallAsync;
import com.valor.common.dac.client.restcall.RestCallSync;
import common.base.tools.exception.ApiException;
import common.config.tools.config.ConfigTools3;
import org.springframework.http.ResponseEntity;
import org.springframework.util.concurrent.ListenableFuture;

public class DACClient {
    public static final String KEY_HOST = "dac.server.host";
    public static String host;

    public static void init() {
    }

    public static void syncCheck(ApiDACRequest apiDACRequest) throws ApiException {
        Gson gson = new Gson();
        String plainPayload = gson.toJson((Object)apiDACRequest);
        host = ConfigTools3.getConfigAsString((String)KEY_HOST, (String)"localhost:20181");
        String url = "http://" + host + "/api/dac/check/v1";
        ApiDACResponse apiDACResponse = RestCallSync.postSync(url, plainPayload, ApiDACResponse.class);
        if (apiDACResponse.getErrCode() != 0) {
            throw new ApiException(apiDACResponse.getRetCode(), apiDACResponse.getErrCode(), apiDACResponse.getErrMsg());
        }
    }

    public static ListenableFuture<ResponseEntity<ApiDACResponse>> asyncCheck(ApiDACRequest apiDACRequest) {
        host = ConfigTools3.getConfigAsString((String)KEY_HOST, (String)"localhost:20181");
        String url = String.format("http://%s/api/dac/check/v1", host);
        ListenableFuture<ResponseEntity<ApiDACResponse>> future = RestCallAsync.postAsync(url, apiDACRequest, ApiDACResponse.class);
        return future;
    }
}

