/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.andriodapk.parser;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.valor.common.andriodapk.model.ApkMetaInfo;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.dongliu.apk.parser.ApkFile;
import org.apache.http.client.fluent.Request;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidApkParser {
    private static final Logger logger = LoggerFactory.getLogger(AndroidApkParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApkMetaInfo parseRemoteApk2(String url) {
        File file = null;
        try {
            String downloadTmpFileName = Files.getNameWithoutExtension((String)url) + "." + Files.getFileExtension((String)url);
            file = File.createTempFile("tmp-apk-", downloadTmpFileName);
            Request.Get((String)url).execute().saveContent(file);
            ApkMetaInfo apkMetaInfo = AndroidApkParser.parseApk(file);
            return apkMetaInfo;
        }
        catch (Exception e) {
            logger.error("Download file[{}] exception:{}", (Object)url, (Object)e);
        }
        finally {
            try {
                if (file != null) {
                    file.delete();
                }
            }
            catch (Exception e) {
                logger.error("Delete file[{}] exception:{}", (Object)file.getAbsolutePath(), (Object)e);
            }
        }
        return null;
    }

    public static ApkMetaInfo parseApk(String filePath) {
        return AndroidApkParser.parseApk(new File(filePath));
    }

    public static void parseElement(Element element, Map<String, String> valueMap, String parentName) {
        if (element.attributeCount() > 0) {
            String name = "";
            String value = "";
            Attribute attrName = element.attribute("name");
            if (attrName != null) {
                name = attrName.getValue();
                Attribute attrValue = element.attribute("value");
                if (attrValue != null) {
                    value = attrValue.getValue();
                }
                if (!Strings.isNullOrEmpty((String)value)) {
                    valueMap.put(name, value);
                }
            }
        }
        for (Element subElement : element.elements()) {
            AndroidApkParser.parseElement(subElement, valueMap, parentName);
        }
    }

    public static Map<String, String> getAndroidManifest(String manifestXml) {
        try {
            Document document = DocumentHelper.parseText((String)manifestXml);
            Element rootElement = document.getRootElement();
            LinkedHashMap valueMap = Maps.newLinkedHashMap();
            AndroidApkParser.parseElement(rootElement, valueMap, "");
            return valueMap;
        }
        catch (DocumentException e) {
            logger.info("Parese manifestXml exception", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ApkMetaInfo parseApk(File file) {
        try (ApkFile apkFile = new ApkFile(file);){
            if (!file.exists()) {
                logger.info("File Not exist!file:{}", (Object)file.getAbsolutePath());
                ApkMetaInfo apkMetaInfo2 = null;
                return apkMetaInfo2;
            }
            ApkMetaInfo apkMetaInfo3 = new ApkMetaInfo();
            apkMetaInfo3.setPackageName(apkFile.getApkMeta().getPackageName());
            apkMetaInfo3.setName(apkFile.getApkMeta().getName());
            apkMetaInfo3.setLabel(apkFile.getApkMeta().getLabel());
            apkMetaInfo3.setVersionName(apkFile.getApkMeta().getVersionName());
            apkMetaInfo3.setVersionCode(apkFile.getApkMeta().getVersionCode());
            apkMetaInfo3.setMinSdkVersion(apkFile.getApkMeta().getMinSdkVersion());
            apkMetaInfo3.setMaxSdkVersion(apkFile.getApkMeta().getMaxSdkVersion());
            apkMetaInfo3.setTargetSdkVersion(apkFile.getApkMeta().getTargetSdkVersion());
            apkMetaInfo3.setIcon(apkFile.getApkMeta().getIcon());
            if (!Strings.isNullOrEmpty((String)apkFile.getManifestXml())) {
                Map<String, String> mainfestMap = AndroidApkParser.getAndroidManifest(apkFile.getManifestXml());
                apkMetaInfo3.setReleaseId(mainfestMap.getOrDefault("UMENG_CHANNEL", ""));
            }
            ApkMetaInfo apkMetaInfo = apkMetaInfo3;
            return apkMetaInfo;
        }
        catch (IOException e) {
            logger.error("Apk file parse exception.apk[{}]", (Object)file.getAbsolutePath(), (Object)e);
            return null;
        }
    }
}

