package comm.base.tools.api.exception;

import com.google.common.base.MoreObjects;

public class ApiExceptionEx extends ApiException {
    private String uid = "";      //uid
    private String lang = "";     // language
    private String protocol = ""; //protocol协议


    public ApiExceptionEx() {
    }

    public ApiExceptionEx(int errCode, String message) {
        super(errCode, message);
    }

    public ApiExceptionEx(int errCode, String message, String protocol, String lang, String id) {
        super(errCode, message);
        this.protocol = protocol;
        this.lang = lang;
        this.uid = id;
    }

    public String getId() {
        return uid;
    }

    public ApiExceptionEx setId(String id) {
        this.uid = id;
        return this;
    }

    public String getProtocol() {
        return protocol;
    }

    public ApiExceptionEx setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getLang() {
        return lang;
    }

    public ApiExceptionEx setLang(String lang) {
        this.lang = lang;
        return this;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("errCode", getErrCode())
                .add("msg", getMessage())
                .add("protocol", protocol)
                .add("lang", lang)
                .add("id", uid)
                .toString();
    }
}
