package comm.base.tools.api.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.Collection;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ApiPagingResponse<T> extends ApiResponse<T> {
    protected int totalCount = 0;
    protected int count = 0;
    protected int pageCount = 1;
    protected int pageId = 0;
    protected int pageSize = 0;

    @Override
    public void setResult(T result) {
        super.setResult(result);
        if (result instanceof Collection) {
            setCount(((Collection) result).size());
        } else {
            setCount(1);
            setTotalCount(1);
        }
    }
}
