/*
 * Decompiled with CFR 0.152.
 */
package comm.base.tools.api.model;

import comm.base.tools.api.model.ApiResponse;
import java.util.Collection;

public class ApiPagingResponse<T>
extends ApiResponse<T> {
    protected int totalCount = 0;
    protected int count = 0;
    protected int pageCount = 1;
    protected int pageId = 0;
    protected int pageSize = 0;

    @Override
    public void setResult(T result) {
        super.setResult(result);
        if (result instanceof Collection) {
            this.setCount(((Collection)result).size());
        } else {
            this.setCount(1);
            this.setTotalCount(1);
        }
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getCount() {
        return this.count;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getPageId() {
        return this.pageId;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public ApiPagingResponse<T> setTotalCount(int totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    public ApiPagingResponse<T> setCount(int count) {
        this.count = count;
        return this;
    }

    public ApiPagingResponse<T> setPageCount(int pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    public ApiPagingResponse<T> setPageId(int pageId) {
        this.pageId = pageId;
        return this;
    }

    public ApiPagingResponse<T> setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiPagingResponse)) {
            return false;
        }
        ApiPagingResponse other = (ApiPagingResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.getPageCount() != other.getPageCount()) {
            return false;
        }
        if (this.getPageId() != other.getPageId()) {
            return false;
        }
        return this.getPageSize() == other.getPageSize();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ApiPagingResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTotalCount();
        result = result * 59 + this.getCount();
        result = result * 59 + this.getPageCount();
        result = result * 59 + this.getPageId();
        result = result * 59 + this.getPageSize();
        return result;
    }

    @Override
    public String toString() {
        return "ApiPagingResponse(super=" + super.toString() + ", totalCount=" + this.getTotalCount() + ", count=" + this.getCount() + ", pageCount=" + this.getPageCount() + ", pageId=" + this.getPageId() + ", pageSize=" + this.getPageSize() + ")";
    }

    public ApiPagingResponse() {
    }

    public ApiPagingResponse(int totalCount, int count, int pageCount, int pageId, int pageSize) {
        this.totalCount = totalCount;
        this.count = count;
        this.pageCount = pageCount;
        this.pageId = pageId;
        this.pageSize = pageSize;
    }
}

