package comm.base.tools.api.model;

import java.util.Collection;


public class ApiPagingResponse<T> extends ApiResponse<T> {
    protected int totalCount = 0;
    protected int count = 0;
    protected int pageCount = 1;
    protected int pageId = 0;
    protected int pageSize = 0;

    public ApiPagingResponse(T result, int totalCount, int count, int pageCount, int pageId, int pageSize) {
        super(result);
        this.totalCount = totalCount;
        this.count = count;
        this.pageCount = pageCount;
        this.pageId = pageId;
        this.pageSize = pageSize;
    }

    @Override
    public void setResult(T result) {
        super.setResult(result);
        if (result instanceof Collection) {
            setCount(((Collection) result).size());
        } else {
            setCount(1);
            setTotalCount(1);
        }
    }

    public int getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getPageCount() {
        return pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getPageId() {
        return pageId;
    }

    public void setPageId(int pageId) {
        this.pageId = pageId;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}
