/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.statistics;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatRangeTools {
    private static final Logger logger = LoggerFactory.getLogger(StatRangeTools.class);
    private static RangeMap<Long, Integer> rangeMap = TreeRangeMap.create();

    private static List<Long> parseRangeConfig(String range) {
        ArrayList timeRangeList = Lists.newArrayList();
        try {
            List rangeList;
            if (!Strings.isNullOrEmpty((String)range) && !(rangeList = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)range)).isEmpty()) {
                for (String v : rangeList) {
                    timeRangeList.add(Long.valueOf(v));
                }
                if (!timeRangeList.isEmpty()) {
                    return timeRangeList;
                }
            }
        }
        catch (Exception e) {
            logger.error("Load Time Range Exception,Use default", (Throwable)e);
        }
        if (timeRangeList.isEmpty()) {
            timeRangeList.addAll(Lists.newArrayList((Object[])new Long[]{0L, 100L, 300L, 500L, 1000L, 3000L, 5000L}));
        }
        logger.info("Load Time Range:[{}]", (Object)Joiner.on((String)",").join((Iterable)timeRangeList));
        return timeRangeList;
    }

    private static void initRange(String range) {
        rangeMap.clear();
        List<Long> timeRange = StatRangeTools.parseRangeConfig(range);
        int maxLevel = timeRange.size();
        for (int i = 0; i < maxLevel; ++i) {
            if (i < maxLevel - 1) {
                rangeMap.put(Range.closedOpen((Comparable)timeRange.get(i), (Comparable)timeRange.get(i + 1)), (Object)i);
                continue;
            }
            rangeMap.put(Range.atLeast((Comparable)timeRange.get(i)), (Object)i);
        }
    }

    public static int getLevel(long val) {
        return (Integer)rangeMap.get((Comparable)Long.valueOf(val));
    }

    public static String getRangeName(int level) {
        for (Map.Entry entry : rangeMap.asMapOfRanges().entrySet()) {
            if (level != (Integer)entry.getValue()) continue;
            return ((Range)entry.getKey()).toString();
        }
        return "unknown";
    }

    static {
        StatRangeTools.initRange("");
    }
}

