/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.type;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringTools {
    private static final Logger logger = LoggerFactory.getLogger(StringTools.class);

    public static Map<String, String> parseAsMap(String str, String entrySeparator, String keyValueSeparator) {
        return StringTools.parseAsMap2(str, entrySeparator, keyValueSeparator);
    }

    public static Map<String, String> parseAsMap2(String str, String entrySeparator, String keyValueSeparator) {
        HashMap valueMap = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)str)) {
            try {
                List entries = Splitter.on((String)entrySeparator).omitEmptyStrings().trimResults().splitToList((CharSequence)str);
                for (String entry : entries) {
                    try {
                        List values = Splitter.on((String)keyValueSeparator).omitEmptyStrings().trimResults().splitToList((CharSequence)entry);
                        if (values.size() != 2) continue;
                        valueMap.put((String)values.get(0), (String)values.get(1));
                    }
                    catch (Exception re) {
                        logger.error("error:[{}]-[{}]-[{}] exception:{}", new Object[]{str, entrySeparator, keyValueSeparator, entry});
                    }
                }
            }
            catch (Exception e) {
                logger.error("STR2MAP error:[{}]-[{}]-[{}] exception:{}", new Object[]{str, entrySeparator, keyValueSeparator, e});
            }
        }
        return valueMap;
    }

    public static List<String> parseAsList(String str, String entrySeparator) {
        if (!Strings.isNullOrEmpty((String)str)) {
            try {
                return Splitter.on((String)entrySeparator).omitEmptyStrings().trimResults().splitToList((CharSequence)str);
            }
            catch (Exception e) {
                logger.error("String To List error:[{}-{}]", (Object)str, (Object)entrySeparator);
            }
        }
        return Lists.newArrayList();
    }

    public static int toInt(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return 0;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            logger.warn("String[{}] cast to int failed:{}", (Object)str, (Object)e);
            return 0;
        }
    }

    public static String firstToUpperCase(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return str;
        }
        String[] strs = str.split(" ");
        ArrayList strList = Lists.newArrayList();
        for (String s : strs) {
            if (Strings.isNullOrEmpty((String)s)) {
                strList.add(s);
                continue;
            }
            strList.add(s.substring(0, 1).toUpperCase() + s.substring(1));
        }
        return Joiner.on((String)" ").join((Iterable)strList);
    }

    public static boolean eq(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        return s1.compareTo(s2) == 0;
    }

    public static String join(String split, Object ... objects) {
        return Joiner.on((String)split).useForNull("*").join(objects);
    }

    public static String join(Object ... objects) {
        return StringTools.join(".", objects);
    }
}

