package common.base.tools.statistics;

import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class ApiQpsStatisticsTools {
    private static final Logger logger = LoggerFactory.getLogger(TimeStatisticsTools2.class);

    // apiName, local-key, server-key, status, duration
    private static Map<String, Map<String, Map<String, Map<Integer, StatQpsItem>>>> VISITS = Maps.newConcurrentMap();

    public static void addVisits(String apiName, String localKey, String serverKey, int status, long duration) {
        Map<String, Map<String, Map<Integer, StatQpsItem>>> apiNameVisits = VISITS.computeIfAbsent(apiName, s -> Maps.newConcurrentMap());
        Map<String, Map<Integer, StatQpsItem>> localKeyVisits = apiNameVisits.computeIfAbsent(localKey, s->Maps.newConcurrentMap());
        Map<Integer, StatQpsItem> serverKeyVisits = localKeyVisits.computeIfAbsent(serverKey, s->Maps.newConcurrentMap());
        StatQpsItem item = serverKeyVisits.computeIfAbsent(status, s->new StatQpsItem(apiName, localKey, serverKey, status));
        item.set(duration);
    }

    public static Map<String, Map<String, Map<String, Map<Integer, StatQpsItem>>>> getAndResetVisits() {
        Map<String, Map<String, Map<String, Map<Integer, StatQpsItem>>>> old = VISITS;
        VISITS = Maps.newConcurrentMap();
        return old;
    }
}
