package common.base.tools.statistics;

import java.util.concurrent.atomic.AtomicLong;

public class StatQpsItem {
    private String apiName;
    private String localKey;
    private String serverKey;
    private int status;
    private long count = 0;
    private long minDurationMs = Long.MAX_VALUE;
    private long maxDurationMs = Long.MIN_VALUE;
    private double avgDurationMs = 0;

    public StatQpsItem(String apiName, String localKey, String serverKey, int status) {
        this.apiName = apiName;
        this.localKey = localKey;
        this.serverKey = serverKey;
        this.status = status;
    }

    public String getApiName() {
        return apiName;
    }

    public String getLocalKey() {
        return localKey;
    }

    public String getServerKey() {
        return serverKey;
    }

    public int getStatus() {
        return status;
    }

    public long getCount() {
        return count;
    }

    public long getMinDurationMs() {
        return minDurationMs;
    }


    public long getMaxDurationMs() {
        return maxDurationMs;
    }


    public double getAvgDurationMs() {
        return avgDurationMs;
    }

    public synchronized void set(long durationMs) {
        minDurationMs = Math.min(minDurationMs, durationMs);
        maxDurationMs = Math.max(maxDurationMs, durationMs);
        count++;
        try {
            avgDurationMs = avgDurationMs + (durationMs - avgDurationMs) / count;
        } catch (Exception ignored){}
    }
}
