/*
 * Decompiled with CFR 0.152.
 */
package common.base.tools.statistics;

import com.google.common.collect.Maps;
import common.base.tools.statistics.StatQpsItem;
import common.base.tools.statistics.TimeStatisticsTools2;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiQpsStatisticsTools {
    private static final Logger logger = LoggerFactory.getLogger(TimeStatisticsTools2.class);
    private static Map<String, Map<String, Map<String, Map<Integer, StatQpsItem>>>> VISITS = Maps.newConcurrentMap();

    public static void addVisits(String apiName, String localKey, String serverKey, int status, long duration) {
        Map apiNameVisits = VISITS.computeIfAbsent(apiName, s -> Maps.newConcurrentMap());
        Map localKeyVisits = apiNameVisits.computeIfAbsent(localKey, s -> Maps.newConcurrentMap());
        Map serverKeyVisits = localKeyVisits.computeIfAbsent(serverKey, s -> Maps.newConcurrentMap());
        StatQpsItem item = serverKeyVisits.computeIfAbsent(status, s -> new StatQpsItem(apiName, localKey, serverKey, status));
        item.set(duration);
    }

    public static Map<String, Map<String, Map<String, Map<Integer, StatQpsItem>>>> getAndResetVisits() {
        Map<String, Map<String, Map<String, Map<Integer, StatQpsItem>>>> old = VISITS;
        VISITS = Maps.newConcurrentMap();
        return old;
    }
}

